/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.common.exception;

import java.util.Optional;
import org.snakeyaml.engine.v2.exceptions.MarkedYamlEngineException;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeType;

public class InvalidNodeTypeException
extends MarkedYamlEngineException {
    public InvalidNodeTypeException(Node node, NodeType expected) {
        super(null, Optional.empty(), "Node type " + InvalidNodeTypeException.nodeTypeName(node.getNodeType()) + " is invalid, expected " + InvalidNodeTypeException.nodeTypeName(expected), node.getStartMark());
    }

    private static String nodeTypeName(NodeType nodeType) {
        switch (nodeType) {
            case ANCHOR: {
                return "anchor";
            }
            case MAPPING: {
                return "map";
            }
            case SCALAR: {
                return "key-value";
            }
            case SEQUENCE: {
                return "array";
            }
        }
        return nodeType.name();
    }
}

