/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ObjectHelper;
import org.jivesoftware.smack.packet.DefaultExtensionElement;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.jiveproperties.JivePropertiesManager;
import org.jivesoftware.smackx.jiveproperties.packet.JivePropertiesExtension;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmppBinding {
    private static final Logger LOG = LoggerFactory.getLogger(XmppBinding.class);
    private HeaderFilterStrategy headerFilterStrategy;

    public XmppBinding() {
        this.headerFilterStrategy = new DefaultHeaderFilterStrategy();
    }

    public XmppBinding(HeaderFilterStrategy headerFilterStrategy) {
        ObjectHelper.notNull((Object)headerFilterStrategy, (String)"headerFilterStrategy");
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public void populateXmppMessage(Message message, Exchange exchange) {
        message.setBody((String)exchange.getIn().getBody(String.class));
        Set entries = exchange.getIn().getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            Object value;
            String name = (String)entry.getKey();
            if (this.headerFilterStrategy.applyFilterToCamelHeaders(name, value = entry.getValue(), exchange)) continue;
            if ("subject".equalsIgnoreCase(name)) {
                String subject = (String)exchange.getContext().getTypeConverter().convertTo(String.class, value);
                message.setSubject(subject);
                continue;
            }
            if ("language".equalsIgnoreCase(name)) {
                String language = (String)exchange.getContext().getTypeConverter().convertTo(String.class, value);
                message.setLanguage(language);
                continue;
            }
            try {
                JivePropertiesManager.addProperty((Stanza)message, (String)name, value);
                LOG.trace("Added property name: {} value: {}", (Object)name, value);
            }
            catch (IllegalArgumentException iae) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Cannot add property " + name + " to XMPP message due: ", (Throwable)iae);
            }
        }
        String id = exchange.getExchangeId();
        if (id != null) {
            JivePropertiesManager.addProperty((Stanza)message, (String)"exchangeId", (Object)id);
        }
    }

    public void populateXmppStanza(Stanza stanza, Exchange exchange) {
        Set entries = exchange.getIn().getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            Object value;
            String name = (String)entry.getKey();
            if (this.headerFilterStrategy.applyFilterToCamelHeaders(name, value = entry.getValue(), exchange)) continue;
            try {
                JivePropertiesManager.addProperty((Stanza)stanza, (String)name, value);
                LOG.debug("Added property name: " + name + " value: " + value);
            }
            catch (IllegalArgumentException iae) {
                LOG.debug("Not adding property " + name + " to XMPP message due to " + iae);
            }
        }
        String id = exchange.getExchangeId();
        if (id != null) {
            JivePropertiesManager.addProperty((Stanza)stanza, (String)"exchangeId", (Object)id);
        }
    }

    public Object extractBodyFromXmpp(Exchange exchange, Stanza stanza) {
        return stanza instanceof Message ? this.getMessageBody((Message)stanza) : stanza;
    }

    private Object getMessageBody(Message message) {
        String messageBody = message.getBody();
        if (messageBody == null) {
            return message;
        }
        return messageBody;
    }

    public Map<String, Object> extractHeadersFromXmpp(Stanza stanza, Exchange exchange) {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        ExtensionElement jpe = stanza.getExtension("http://www.jivesoftware.com/xmlns/xmpp/properties");
        if (jpe instanceof JivePropertiesExtension) {
            this.extractHeadersFrom((JivePropertiesExtension)jpe, exchange, answer);
        }
        if (jpe instanceof DefaultExtensionElement) {
            this.extractHeadersFrom((DefaultExtensionElement)jpe, exchange, answer);
        }
        if (stanza instanceof Message) {
            Message xmppMessage = (Message)stanza;
            answer.put("CamelXmppMessageType", xmppMessage.getType());
            answer.put("CamelXmppSubject", xmppMessage.getSubject());
            answer.put("CamelXmppThreadID", xmppMessage.getThread());
        } else if (stanza instanceof PubSub) {
            PubSub pubsubPacket = (PubSub)stanza;
            answer.put("CamelXmppMessageType", pubsubPacket.getType());
        }
        answer.put("CamelXmppFrom", stanza.getFrom());
        answer.put("CamelXmppPacketID", stanza.getStanzaId());
        answer.put("CamelXmppStanzaID", stanza.getStanzaId());
        answer.put("CamelXmppTo", stanza.getTo());
        return answer;
    }

    private void extractHeadersFrom(JivePropertiesExtension jpe, Exchange exchange, Map<String, Object> answer) {
        for (String name : jpe.getPropertyNames()) {
            Object value;
            if (this.headerFilterStrategy.applyFilterToExternalHeaders(name, value = jpe.getProperty(name), exchange)) continue;
            answer.put(name, value);
        }
    }

    private void extractHeadersFrom(DefaultExtensionElement jpe, Exchange exchange, Map<String, Object> answer) {
        for (String name : jpe.getNames()) {
            String value;
            if (this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)(value = jpe.getValue(name)), exchange)) continue;
            answer.put(name, value);
        }
    }
}

