/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.xmlsecurity.XmlSecurityProducer;
import org.apache.camel.component.xmlsecurity.XmlVerifierComponent;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureConstants;
import org.apache.camel.component.xmlsecurity.processor.XmlVerifierConfiguration;
import org.apache.camel.component.xmlsecurity.processor.XmlVerifierProcessor;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.12.0", scheme="xmlsecurity-verify", title="XML Security Verify", syntax="xmlsecurity-verify:name", producerOnly=true, category={Category.SECURITY, Category.TRANSFORMATION}, remote=false, headersClass=XmlSignatureConstants.class)
public class XmlVerifierEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true)
    private String name;
    @UriParam
    private XmlVerifierConfiguration configuration;

    public XmlVerifierEndpoint(String uri, XmlVerifierComponent component, XmlVerifierConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public boolean isRemote() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public XmlVerifierConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(XmlVerifierConfiguration configuration) {
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        XmlVerifierProcessor processor = new XmlVerifierProcessor(this.getCamelContext(), this.getConfiguration());
        return new XmlSecurityProducer((Endpoint)this, processor);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return null;
    }

    protected void doInit() throws Exception {
        super.doInit();
        Object ns = this.configuration.getOutputNodeSearch();
        if (!(ns instanceof String) || ns.toString().startsWith("#")) {
            // empty if block
        }
    }
}

