/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.processor;

import javax.xml.crypto.KeySelector;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.xmlsecurity.api.DefaultValidationFailedHandler;
import org.apache.camel.component.xmlsecurity.api.DefaultXmlSignature2Message;
import org.apache.camel.component.xmlsecurity.api.ValidationFailedHandler;
import org.apache.camel.component.xmlsecurity.api.XmlSignature2Message;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureChecker;
import org.apache.camel.component.xmlsecurity.processor.XmlSignatureConfiguration;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class XmlVerifierConfiguration
extends XmlSignatureConfiguration {
    @UriParam(label="verify")
    private KeySelector keySelector;
    private String keySelectorName;
    @UriParam(label="verify")
    private XmlSignatureChecker xmlSignatureChecker;
    private String xmlSignatureCheckerName;
    @UriParam(label="verify")
    private XmlSignature2Message xmlSignature2Message = new DefaultXmlSignature2Message();
    private String xmlSignature2MessageName;
    @UriParam(label="verify")
    private ValidationFailedHandler validationFailedHandler = new DefaultValidationFailedHandler();
    private String validationFailedHandlerName;
    @UriParam(label="verify", javaType="java.lang.String")
    private Object outputNodeSearch;
    @UriParam(label="verify", defaultValue="Default")
    private String outputNodeSearchType = "Default";
    @UriParam(label="verify", defaultValue="false")
    private Boolean removeSignatureElements = Boolean.FALSE;
    @UriParam(label="verify", defaultValue="true")
    private Boolean secureValidation = Boolean.TRUE;

    public XmlVerifierConfiguration copy() {
        try {
            return (XmlVerifierConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        super.setCamelContext(camelContext);
        this.setKeySelector(this.keySelectorName);
        this.setXmlSignatureChecker(this.xmlSignatureCheckerName);
        this.setXmlSignature2Message(this.xmlSignature2MessageName);
        this.setValidationFailedHandler(this.validationFailedHandlerName);
    }

    public void setKeySelector(KeySelector keySelector) {
        this.keySelector = keySelector;
    }

    public KeySelector getKeySelector() {
        return this.keySelector;
    }

    public void setKeySelector(String keySelectorName) {
        KeySelector selector;
        if (this.getCamelContext() != null && keySelectorName != null && (selector = (KeySelector)this.getCamelContext().getRegistry().lookupByNameAndType(keySelectorName, KeySelector.class)) != null) {
            this.setKeySelector(selector);
        }
        if (keySelectorName != null) {
            this.keySelectorName = keySelectorName;
        }
    }

    public XmlSignatureChecker getXmlSignatureChecker() {
        return this.xmlSignatureChecker;
    }

    public void setXmlSignatureChecker(XmlSignatureChecker xmlSignatureChecker) {
        this.xmlSignatureChecker = xmlSignatureChecker;
    }

    public void setXmlSignatureChecker(String xmlSignatureCheckerName) {
        XmlSignatureChecker checker;
        if (this.getCamelContext() != null && xmlSignatureCheckerName != null && (checker = (XmlSignatureChecker)this.getCamelContext().getRegistry().lookupByNameAndType(xmlSignatureCheckerName, XmlSignatureChecker.class)) != null) {
            this.setXmlSignatureChecker(checker);
        }
        if (xmlSignatureCheckerName != null) {
            this.xmlSignatureCheckerName = xmlSignatureCheckerName;
        }
    }

    public XmlSignature2Message getXmlSignature2Message() {
        return this.xmlSignature2Message;
    }

    public void setXmlSignature2Message(XmlSignature2Message xmlSignature2Message) {
        this.xmlSignature2Message = xmlSignature2Message;
    }

    public void setXmlSignature2Message(String xmlSignature2Message) {
        XmlSignature2Message maper;
        if (this.getCamelContext() != null && xmlSignature2Message != null && (maper = (XmlSignature2Message)this.getCamelContext().getRegistry().lookupByNameAndType(xmlSignature2Message, XmlSignature2Message.class)) != null) {
            this.setXmlSignature2Message(maper);
        }
        if (xmlSignature2Message != null) {
            this.xmlSignature2MessageName = xmlSignature2Message;
        }
    }

    public ValidationFailedHandler getValidationFailedHandler() {
        return this.validationFailedHandler;
    }

    public void setValidationFailedHandler(ValidationFailedHandler validationFailedHandler) {
        this.validationFailedHandler = validationFailedHandler;
    }

    public void setValidationFailedHandler(String validationFailedHandlerName) {
        ValidationFailedHandler vailFailedHandler;
        if (this.getCamelContext() != null && validationFailedHandlerName != null && (vailFailedHandler = (ValidationFailedHandler)this.getCamelContext().getRegistry().lookupByNameAndType(validationFailedHandlerName, ValidationFailedHandler.class)) != null) {
            this.setValidationFailedHandler(vailFailedHandler);
        }
        if (validationFailedHandlerName != null) {
            this.validationFailedHandlerName = validationFailedHandlerName;
        }
    }

    public Object getOutputNodeSearch() {
        return this.outputNodeSearch;
    }

    public void setOutputNodeSearch(Object outputNodeSearch) {
        this.outputNodeSearch = outputNodeSearch;
    }

    public String getOutputNodeSearchType() {
        return this.outputNodeSearchType;
    }

    public void setOutputNodeSearchType(String outputNodeSearchType) {
        this.outputNodeSearchType = outputNodeSearchType;
    }

    public Boolean getRemoveSignatureElements() {
        return this.removeSignatureElements;
    }

    public void setRemoveSignatureElements(Boolean removeSignatureElements) {
        this.removeSignatureElements = removeSignatureElements;
    }

    public Boolean getSecureValidation() {
        return this.secureValidation;
    }

    public void setSecureValidation(Boolean secureValidation) {
        this.secureValidation = secureValidation;
    }

    public String getValidationFailedHandlerName() {
        return this.validationFailedHandlerName;
    }

    public void setValidationFailedHandlerName(String validationFailedHandlerName) {
        this.validationFailedHandlerName = validationFailedHandlerName;
    }
}

