/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.workday.auth;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import org.apache.camel.component.workday.WorkdayConfiguration;
import org.apache.camel.component.workday.auth.AuthenticationClient;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.message.StatusLine;

public class AuthClientForIntegration
implements AuthenticationClient {
    public static final String BASE_TOKEN_ENDPOINT = "https://%s/ccx/oauth2/%s/token";
    private static final String GRANT_TYPE = "grant_type";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private final WorkdayConfiguration workdayConfiguration;

    public AuthClientForIntegration(WorkdayConfiguration workdayConfiguration) {
        this.workdayConfiguration = workdayConfiguration;
    }

    @Override
    public void configure(CloseableHttpClient httpClient, HttpUriRequest method) throws IOException {
        String bearerToken = this.getBearerToken(httpClient);
        method.addHeader(AUTHORIZATION_HEADER, (Object)("Bearer " + bearerToken));
    }

    protected String getBearerToken(CloseableHttpClient httpClient) throws IOException {
        String tokenUrl = String.format(BASE_TOKEN_ENDPOINT, this.workdayConfiguration.getHost(), this.workdayConfiguration.getTenant());
        HttpPost httpPost = this.createPostMethod(tokenUrl);
        return (String)httpClient.execute((ClassicHttpRequest)httpPost, httpResponse -> {
            if (httpResponse.getCode() != 200) {
                throw new IllegalStateException("Got the invalid http status value '" + String.valueOf(new StatusLine((HttpResponse)httpResponse)) + "' as the result of the Token Request '" + tokenUrl + "'");
            }
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                httpResponse.getEntity().writeTo((OutputStream)baos);
                String string = this.parseResponse(baos.toString());
                return string;
            }
        });
    }

    private HttpPost createPostMethod(String tokenUrl) {
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair(GRANT_TYPE, REFRESH_TOKEN));
        nvps.add(new BasicNameValuePair(REFRESH_TOKEN, this.workdayConfiguration.getTokenRefresh()));
        HttpPost postMethod = new HttpPost(tokenUrl);
        postMethod.addHeader(CONTENT_TYPE_HEADER, (Object)CONTENT_TYPE);
        postMethod.addHeader(AUTHORIZATION_HEADER, (Object)("Basic " + Arrays.toString(Base64.getEncoder().encode((this.workdayConfiguration.getClientId() + ":" + this.workdayConfiguration.getClientSecret()).getBytes()))));
        postMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
        return postMethod;
    }

    private String parseResponse(String response) {
        int tokenIdx = response.indexOf(ACCESS_TOKEN);
        if (tokenIdx < 1) {
            throw new IllegalStateException("No valid access token response.");
        }
        response = response.substring(response.indexOf(ACCESS_TOKEN) + 16, response.length() - 3);
        return response;
    }
}

