/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.workday;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.Map;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

@UriParams
public class WorkdayConfiguration {
    @UriPath(description="The entity to be requested or subscribed via API.", enums="report,commonAPI")
    @Metadata(required=true)
    private Entity entity;
    @UriPath(description="The API path to access an entity structure.")
    @Metadata(required=true)
    private String path;
    @UriParam(label="security", secret=true, description="Workday client Id generated by API client for integrations.")
    @Metadata(required=true)
    private String clientId;
    @UriParam(label="security", secret=true, description="Workday client Secret generated by API client for integrations.")
    @Metadata(required=true)
    private String clientSecret;
    @UriParam(label="security", secret=true, description="Workday token Refresh generated for integrations system user.")
    @Metadata(required=true)
    private String tokenRefresh;
    @UriParam(label="host", description="Workday Host name.")
    @Metadata(required=true)
    private String host;
    @UriParam(label="tenant", description="Workday Tenant name.")
    @Metadata(required=true)
    private String tenant;
    @UriParam(label="format", description="Workday Report as a service output format.", enums="json", defaultValue="json")
    private String reportFormat = "json";
    @UriParam(label="advanced", description="Pool connection manager for advanced configuration.")
    private PoolingHttpClientConnectionManager httpConnectionManager = new PoolingHttpClientConnectionManager();
    private Map<String, Object> parameters;

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getTokenRefresh() {
        return this.tokenRefresh;
    }

    public void setTokenRefresh(String tokenRefresh) {
        this.tokenRefresh = tokenRefresh;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public PoolingHttpClientConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public void setHttpConnectionManager(PoolingHttpClientConnectionManager httpConnectionManager) {
        this.httpConnectionManager = httpConnectionManager;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void parseURI(String remaining, Map<String, Object> parameters) throws Exception {
        String path;
        String entity;
        try {
            URI u = new URI(remaining);
            entity = u.getScheme();
            path = u.getPath();
        }
        catch (Exception e) {
            throw new MalformedURLException(String.format("An invalid workday remaining uri: '%s' was provided. Error: '%s'", remaining, e.getMessage()));
        }
        ObjectHelper.notNull((Object)entity, (String)"Entity");
        this.setPath(path);
        this.setEntity(Entity.valueOf(entity));
        this.setParameters(parameters);
    }

    public static enum Entity {
        report,
        commonAPI;

    }
}

