/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress.producer;

import org.apache.camel.Exchange;
import org.apache.camel.component.wordpress.WordpressEndpoint;
import org.apache.camel.component.wordpress.api.WordpressServiceProvider;
import org.apache.camel.component.wordpress.api.model.User;
import org.apache.camel.component.wordpress.api.service.WordpressServiceUsers;
import org.apache.camel.component.wordpress.producer.AbstractWordpressProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordpressUserProducer
extends AbstractWordpressProducer<User> {
    private static final Logger LOG = LoggerFactory.getLogger(WordpressUserProducer.class);
    private WordpressServiceUsers serviceUsers = WordpressServiceProvider.getInstance().getService(WordpressServiceUsers.class);

    public WordpressUserProducer(WordpressEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected User processDelete(Exchange exchange) {
        LOG.debug("Trying to delete user {}", (Object)this.getConfiguration().getId());
        return (User)this.serviceUsers.delete(this.getConfiguration().getId());
    }

    @Override
    protected User processUpdate(Exchange exchange) {
        LOG.debug("Trying to update the user {} with id {}", exchange.getIn().getBody(), (Object)this.getConfiguration().getId());
        return this.serviceUsers.update(this.getConfiguration().getId(), (User)exchange.getIn().getBody(User.class));
    }

    @Override
    protected User processInsert(Exchange exchange) {
        LOG.debug("Trying to create a new user{}", exchange.getIn().getBody());
        return this.serviceUsers.create((User)exchange.getIn().getBody(User.class));
    }
}

