/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.whatsapp.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.whatsapp.WhatsAppService;
import org.apache.camel.component.whatsapp.model.BaseMessage;
import org.apache.camel.component.whatsapp.model.ContactMessageRequest;
import org.apache.camel.component.whatsapp.model.InteractiveMessageRequest;
import org.apache.camel.component.whatsapp.model.LocationMessageRequest;
import org.apache.camel.component.whatsapp.model.MediaMessageRequest;
import org.apache.camel.component.whatsapp.model.MessageResponse;
import org.apache.camel.component.whatsapp.model.TemplateMessageRequest;
import org.apache.camel.component.whatsapp.model.TextMessageRequest;
import org.apache.camel.component.whatsapp.model.UploadMediaRequest;
import org.apache.camel.component.whatsapp.util.FileUploadStreamSupplier;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhatsAppServiceRestAPIAdapter
implements WhatsAppService {
    private static final Logger LOG = LoggerFactory.getLogger(WhatsAppServiceRestAPIAdapter.class);
    private static final String MESSAGES_ENDPOINT = "/messages";
    private static final String MEDIA_ENDPOINT = "/media";
    private final Map<Class<?>, OutgoingMessageHandler<?>> handlers;
    private final ObjectMapper mapper;
    private final String baseUri;
    private final String authorizationToken;

    public WhatsAppServiceRestAPIAdapter(HttpClient client, String baseUri, String apiVersion, String phoneNumberId, String authorizationToken) {
        this.baseUri = baseUri + "/" + apiVersion + "/" + phoneNumberId;
        this.mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.authorizationToken = authorizationToken;
        HashMap m = new HashMap();
        m.put(TextMessageRequest.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + MESSAGES_ENDPOINT));
        m.put(MediaMessageRequest.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + MESSAGES_ENDPOINT));
        m.put(LocationMessageRequest.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + MESSAGES_ENDPOINT));
        m.put(ContactMessageRequest.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + MESSAGES_ENDPOINT));
        m.put(InteractiveMessageRequest.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + MESSAGES_ENDPOINT));
        m.put(UploadMediaRequest.class, new OutgoingMediaMessageHandler(client, this.mapper, this.baseUri + MEDIA_ENDPOINT));
        m.put(TemplateMessageRequest.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + MESSAGES_ENDPOINT));
        this.handlers = m;
    }

    @Override
    public void sendMessage(Exchange exchange, AsyncCallback callback, BaseMessage message) {
        OutgoingMessageHandler<?> handler = this.handlers.get(message.getClass());
        ObjectHelper.notNull(handler, (String)"handler");
        try {
            handler.sendMessage(exchange, callback, message, this.authorizationToken);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeCamelException("Could not send message " + message, (Throwable)e);
        }
    }

    static abstract class OutgoingMessageHandler<T extends BaseMessage> {
        protected final ObjectMapper mapper;
        private final HttpClient httpClient;
        private final String contentType;
        private final String uri;
        private final Class<? extends MessageResponse> resultClass;

        public OutgoingMessageHandler(HttpClient httpClient, ObjectMapper mapper, String uri, String contentType, Class<? extends MessageResponse> resultClass) {
            this.resultClass = resultClass;
            this.httpClient = httpClient;
            this.mapper = mapper;
            this.uri = uri;
            this.contentType = contentType;
        }

        public void sendMessage(Exchange exchange, AsyncCallback callback, T message, String authorizationToken) throws IOException, InterruptedException {
            HttpRequest.Builder httpRequestBuilder = HttpRequest.newBuilder();
            if (this.contentType != null) {
                httpRequestBuilder.header("content-type", this.contentType);
            }
            httpRequestBuilder.header("Authorization", "Bearer " + authorizationToken);
            httpRequestBuilder.header("Accept", "application/json");
            this.addBody(httpRequestBuilder, message);
            httpRequestBuilder.uri(URI.create(this.uri));
            CompletableFuture<HttpResponse<String>> asyncResponse = this.httpClient.sendAsync(httpRequestBuilder.build(), HttpResponse.BodyHandlers.ofString());
            asyncResponse.thenAccept(response -> {
                block6: {
                    try {
                        boolean success;
                        int statusCode = response.statusCode();
                        LOG.info("Response received with status {} and body {}", (Object)statusCode, response.body());
                        boolean bl = success = statusCode >= 200 && statusCode < 300;
                        if (success) {
                            Object result = this.mapper.readValue((String)response.body(), this.resultClass);
                            exchange.getMessage().setBody(result);
                            break block6;
                        }
                        LOG.debug("Error response Headers {}", (Object)response.headers());
                        RuntimeCamelException exception = new RuntimeCamelException(this.uri + " responded: " + statusCode + " and body: " + (String)response.body());
                        exchange.setException((Throwable)exception);
                        throw exception;
                    }
                    catch (JsonProcessingException e) {
                        exchange.setException((Throwable)e);
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                    }
                    finally {
                        callback.done(false);
                    }
                }
            });
        }

        protected abstract void addBody(HttpRequest.Builder var1, T var2);
    }

    static class OutgoingPlainMessageHandler
    extends OutgoingMessageHandler<BaseMessage> {
        public OutgoingPlainMessageHandler(HttpClient httpClient, ObjectMapper mapper, String uri, Class<? extends MessageResponse> returnType) {
            super(httpClient, mapper, uri, "application/json", returnType);
        }

        public OutgoingPlainMessageHandler(HttpClient httpClient, ObjectMapper mapper, String uri) {
            this(httpClient, mapper, uri, MessageResponse.class);
        }

        @Override
        protected void addBody(HttpRequest.Builder builder, BaseMessage message) {
            try {
                String body = this.mapper.writeValueAsString((Object)message);
                HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofString(body);
                builder.POST(bodyPublisher);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeCamelException("Could not serialize " + message, (Throwable)e);
            }
        }
    }

    static class OutgoingMediaMessageHandler
    extends OutgoingMessageHandler<UploadMediaRequest> {
        public OutgoingMediaMessageHandler(HttpClient httpClient, ObjectMapper mapper, String uri, Class<? extends MessageResponse> resultClass) {
            super(httpClient, mapper, uri, null, resultClass);
        }

        public OutgoingMediaMessageHandler(HttpClient httpClient, ObjectMapper mapper, String uri) {
            this(httpClient, mapper, uri, MessageResponse.class);
        }

        @Override
        protected void addBody(HttpRequest.Builder builder, UploadMediaRequest message) {
            HashMap<Object, Object> formData = new HashMap<Object, Object>();
            formData.put("messaging_product", "whatsapp");
            formData.put("file", message.getUploadMedia());
            String boundary = new BigInteger(256, new Random()).toString();
            try {
                builder.POST(OutgoingMediaMessageHandler.ofStreamPart(formData, boundary));
            }
            catch (IOException e) {
                throw new RuntimeCamelException("Could not serialize " + message, (Throwable)e);
            }
            builder.header("content-type", "multipart/form-data; boundary=" + boundary);
        }

        public static HttpRequest.BodyPublisher ofStreamPart(Map<Object, Object> data, String boundary) throws IOException {
            Supplier<? extends InputStream> streamSupplier = new FileUploadStreamSupplier(data, boundary).generate();
            return HttpRequest.BodyPublishers.ofInputStream(streamSupplier);
        }
    }
}

