/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.whatsapp.util;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.whatsapp.model.UploadMedia;
import org.apache.camel.component.whatsapp.util.RestAdapterUtils;

public class FileUploadStreamSupplier {
    private InputStream preFileIS;
    private InputStream fileIS;
    private InputStream postFileIS;
    private final Map<Object, Object> data;
    private final String boundary;

    public FileUploadStreamSupplier(Map<Object, Object> data, String boundary) {
        this.data = data;
        this.boundary = boundary;
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        byte[] boundaryBytes = boundary.getBytes();
        ByteBuffer separatorBuffer = RestAdapterUtils.generateByteBuffer(RestAdapterUtils.EXTRA_BYTES, boundaryBytes, RestAdapterUtils.NEW_LINE_BYTES, RestAdapterUtils.CONTENT_DISPOSITION_BYTES);
        byte[] separator = separatorBuffer.array();
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            byteArrays.add(separator);
            byte[] keyBytes = ((String)entry.getKey()).getBytes();
            if (entry.getValue() instanceof UploadMedia) {
                UploadMedia uploadMedia = (UploadMedia)entry.getValue();
                this.generateUploadMediaStream(byteArrays, keyBytes, uploadMedia);
                continue;
            }
            byte[] entryStringBytes = entry.getValue().toString().getBytes();
            ByteBuffer stringBuffer = RestAdapterUtils.generateByteBuffer(RestAdapterUtils.QUOTE_BYTES, keyBytes, RestAdapterUtils.NEW_LINE_BYTES, RestAdapterUtils.NEW_LINE_BYTES, entryStringBytes, RestAdapterUtils.NEW_LINE_BYTES);
            byteArrays.add(stringBuffer.array());
        }
        ByteBuffer endBuffer = RestAdapterUtils.generateByteBuffer(RestAdapterUtils.EXTRA_BYTES, boundaryBytes, RestAdapterUtils.EXTRA_BYTES, RestAdapterUtils.NEW_LINE_BYTES);
        byteArrays.add(endBuffer.array());
        ByteBuffer postFileBytes = RestAdapterUtils.generateByteBuffer(byteArrays);
        this.postFileIS = new ByteArrayInputStream(postFileBytes.array());
    }

    private void generateUploadMediaStream(List<byte[]> byteArrays, byte[] keyBytes, UploadMedia uploadMedia) {
        byte[] fileNameBytes;
        if (uploadMedia.getFile() != null) {
            fileNameBytes = uploadMedia.getFile().toPath().getFileName().toString().getBytes();
            try {
                this.fileIS = new FileInputStream(uploadMedia.getFile());
            }
            catch (FileNotFoundException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        } else {
            fileNameBytes = uploadMedia.getName().getBytes();
            this.fileIS = uploadMedia.getFileStream();
        }
        byte[] contentTypeBytes = uploadMedia.getContentType().getBytes();
        ByteBuffer uploadMediaBuffer = RestAdapterUtils.generateByteBuffer(RestAdapterUtils.QUOTE_BYTES, keyBytes, RestAdapterUtils.FILE_NAME_HEADER_BYTES, fileNameBytes, RestAdapterUtils.CONTENT_TYPE_HEADER_BYTES, contentTypeBytes, RestAdapterUtils.NEW_LINE_BYTES, RestAdapterUtils.NEW_LINE_BYTES);
        byteArrays.add(uploadMediaBuffer.array());
        ByteBuffer preFileBytes = RestAdapterUtils.generateByteBuffer(byteArrays);
        this.preFileIS = new ByteArrayInputStream(preFileBytes.array());
        byteArrays.clear();
        byteArrays.add(RestAdapterUtils.NEW_LINE_BYTES);
    }

    public Supplier<? extends InputStream> generate() {
        return () -> new SequenceInputStream(this.preFileIS, new SequenceInputStream(this.fileIS, this.postFileIS));
    }

    public Map<Object, Object> getData() {
        return this.data;
    }

    public String getBoundary() {
        return this.boundary;
    }
}

