/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.whatsapp;

import java.net.http.HttpClient;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.whatsapp.WhatsAppConfiguration;
import org.apache.camel.component.whatsapp.WhatsAppEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@org.apache.camel.spi.annotations.Component(value="whatsapp")
public class WhatsAppComponent
extends DefaultComponent {
    public static final String API_DEFAULT_URL = "https://graph.facebook.com";
    public static final String API_DEFAULT_VERSION = "v13.0";
    @Metadata(required=true, description="Phone Number ID taken from WhatsApp Meta for Developers Dashboard")
    private String phoneNumberId;
    @Metadata(label="security", secret=true, required=true, description="Authorization Token taken from WhatsApp Meta for Developers Dashboard")
    private String authorizationToken;
    @Metadata(label="advanced", description="Java 11 HttpClient implementation")
    private HttpClient client;
    @Metadata(label="advanced", defaultValue="https://graph.facebook.com", description="Can be used to set an alternative base URI, e.g. when you want to test the component against a mock WhatsApp API")
    private String baseUri = "https://graph.facebook.com";
    @Metadata(label="advanced", defaultValue="v13.0", description="WhatsApp Cloud API version")
    private String apiVersion = "v13.0";
    @Metadata(description="Webhook verify token", label="advanced", secret=true)
    private String webhookVerifyToken;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        WhatsAppConfiguration configuration = new WhatsAppConfiguration();
        if (configuration.getBaseUri() == null) {
            configuration.setBaseUri(this.baseUri);
        }
        if (configuration.getApiVersion() == null) {
            configuration.setApiVersion(this.apiVersion);
        }
        if (configuration.getWebhookVerifyToken() == null) {
            configuration.setWebhookVerifyToken(this.webhookVerifyToken);
        }
        configuration.setAuthorizationToken(this.authorizationToken);
        if (remaining.endsWith("/")) {
            remaining = remaining.substring(0, remaining.length() - 1);
        }
        configuration.setPhoneNumberId(remaining);
        WhatsAppEndpoint endpoint = new WhatsAppEndpoint(uri, (Component)this, configuration, this.client);
        this.setProperties((Endpoint)endpoint, parameters);
        if (ObjectHelper.isEmpty((String)endpoint.getConfiguration().getAuthorizationToken())) {
            throw new IllegalArgumentException("AuthorizationToken must be configured on either component or endpoint for whatsapp: " + uri);
        }
        return endpoint;
    }

    public String getPhoneNumberId() {
        return this.phoneNumberId;
    }

    public void setPhoneNumberId(String phoneNumberId) {
        this.phoneNumberId = phoneNumberId;
    }

    public String getAuthorizationToken() {
        return this.authorizationToken;
    }

    public void setAuthorizationToken(String authorizationToken) {
        this.authorizationToken = authorizationToken;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getWebhookVerifyToken() {
        return this.webhookVerifyToken;
    }

    public void setWebhookVerifyToken(String webhookVerifyToken) {
        this.webhookVerifyToken = webhookVerifyToken;
    }
}

