/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weka;

import io.nessus.weka.Dataset;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.weka.WekaTypeConverters;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import weka.core.Instances;

@DeferredContextBinding
public final class WekaTypeConvertersLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        WekaTypeConvertersLoader.addTypeConverter(registry, Dataset.class, File.class, false, (type, exchange, value) -> WekaTypeConverters.toDataset((File)value));
        WekaTypeConvertersLoader.addTypeConverter(registry, Dataset.class, InputStream.class, false, (type, exchange, value) -> WekaTypeConverters.toDataset((InputStream)value));
        WekaTypeConvertersLoader.addTypeConverter(registry, Dataset.class, URL.class, false, (type, exchange, value) -> WekaTypeConverters.toDataset((URL)value));
        WekaTypeConvertersLoader.addTypeConverter(registry, Dataset.class, Path.class, false, (type, exchange, value) -> WekaTypeConverters.toDataset((Path)value));
        WekaTypeConvertersLoader.addTypeConverter(registry, Dataset.class, Instances.class, false, (type, exchange, value) -> WekaTypeConverters.toDataset((Instances)value));
        WekaTypeConvertersLoader.addTypeConverter(registry, InputStream.class, Dataset.class, false, (type, exchange, value) -> WekaTypeConverters.toInputStream((Dataset)value));
        WekaTypeConvertersLoader.addTypeConverter(registry, InputStream.class, Instances.class, false, (type, exchange, value) -> WekaTypeConverters.toInputStream((Instances)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

