/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weka;

import io.nessus.weka.Dataset;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import org.apache.camel.Converter;
import weka.core.Instances;

@Converter(generateLoader=true)
public final class WekaTypeConverters {
    private WekaTypeConverters() {
    }

    @Converter
    public static InputStream toInputStream(Dataset dataset) {
        Instances instances = dataset.getInstances();
        return WekaTypeConverters.toInputStream(instances);
    }

    @Converter
    public static InputStream toInputStream(Instances instances) {
        byte[] bytes = instances.toString().getBytes();
        return new ByteArrayInputStream(bytes);
    }

    @Converter
    public static Dataset toDataset(Instances instances) {
        return Dataset.create((Instances)instances);
    }

    @Converter
    public static Dataset toDataset(InputStream input) {
        return Dataset.create((InputStream)input);
    }

    @Converter
    public static Dataset toDataset(File infile) {
        return Dataset.create((Path)infile.toPath());
    }

    @Converter
    public static Dataset toDataset(Path inpath) {
        return Dataset.create((Path)inpath);
    }

    @Converter
    public static Dataset toDataset(URL url) {
        return Dataset.create((URL)url);
    }
}

