/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.websocket;

import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.websocket.DefaultNodeSynchronization;
import org.apache.camel.component.websocket.DefaultWebsocketFactory;
import org.apache.camel.component.websocket.JettyClassPathResource;
import org.apache.camel.component.websocket.MemoryWebsocketStore;
import org.apache.camel.component.websocket.NodeSynchronization;
import org.apache.camel.component.websocket.WebSocketFactory;
import org.apache.camel.component.websocket.WebsocketComponentServlet;
import org.apache.camel.component.websocket.WebsocketConsumer;
import org.apache.camel.component.websocket.WebsocketEndpoint;
import org.apache.camel.component.websocket.WebsocketProducer;
import org.apache.camel.component.websocket.WebsocketProducerConsumer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="websocket")
public class WebsocketComponent
extends DefaultComponent
implements SSLContextParametersAware {
    protected static final Logger LOG = LoggerFactory.getLogger(WebsocketComponent.class);
    protected static final HashMap<String, ConnectorRef> CONNECTORS = new HashMap();
    protected Map<String, WebSocketFactory> socketFactory;
    protected Server staticResourcesServer;
    protected MBeanContainer mbContainer;
    @Metadata(label="security")
    protected SSLContextParameters sslContextParameters;
    @Metadata(label="security", defaultValue="false")
    protected boolean useGlobalSslContextParameters;
    @Metadata(label="advanced")
    protected ThreadPool threadPool;
    @Metadata(defaultValue="9292")
    protected Integer port = 9292;
    @Metadata(label="advanced")
    protected Integer minThreads;
    @Metadata(label="advanced")
    protected Integer maxThreads;
    @Metadata(label="advanced")
    protected boolean enableJmx;
    @Metadata(defaultValue="0.0.0.0")
    protected String host = "0.0.0.0";
    @Metadata(label="consumer")
    protected String staticResources;
    @Metadata(label="security", secret=true)
    protected String sslKeyPassword;
    @Metadata(label="security", secret=true)
    protected String sslPassword;
    @Metadata(label="security", secret=true)
    protected String sslKeystore;
    @Metadata(label="advanced", defaultValue="any")
    protected String subprotocol = "any";
    private Map<String, WebsocketComponentServlet> servlets = new HashMap<String, WebsocketComponentServlet>();

    public WebsocketComponent() {
        if (this.socketFactory == null) {
            this.socketFactory = new HashMap<String, WebSocketFactory>();
            this.socketFactory.put("default", new DefaultWebsocketFactory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(WebsocketProducerConsumer prodcon) throws Exception {
        Server server = null;
        WebsocketEndpoint endpoint = prodcon.getEndpoint();
        String connectorKey = WebsocketComponent.getConnectorKey(endpoint);
        HashMap<String, ConnectorRef> hashMap = CONNECTORS;
        synchronized (hashMap) {
            ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
            if (connectorRef == null) {
                server = this.createServer();
                if (endpoint.isEnableJmx()) {
                    this.enableJmx(server);
                }
                ServerConnector connector = endpoint.getSslContextParameters() != null ? this.getSslSocketConnector(server, endpoint.getSslContextParameters()) : new ServerConnector(server);
                if (endpoint.getPort() != null) {
                    connector.setPort(endpoint.getPort().intValue());
                } else {
                    connector.setPort(this.port.intValue());
                }
                if (endpoint.getHost() != null) {
                    connector.setHost(endpoint.getHost());
                } else {
                    connector.setHost(this.host);
                }
                server.addConnector((Connector)connector);
                LOG.trace("Jetty Connector added: {}", (Object)connector.getName());
                ServletContextHandler context = this.createContext(server, (Connector)connector, endpoint.getHandlers());
                this.setWebSocketComponentServletInitialParameter(context, endpoint);
                server.setHandler((Handler)context);
                this.applyCrossOriginFiltering(endpoint, context);
                if (endpoint.getStaticResources() != null) {
                    server = this.createStaticResourcesServer(server, context, endpoint.getStaticResources());
                }
                MemoryWebsocketStore memoryStore = new MemoryWebsocketStore();
                connectorRef = new ConnectorRef(server, connector, null, memoryStore);
                if (endpoint.isSessionSupport()) {
                    this.enableSessionSupport(connectorRef.server, connectorKey);
                }
                LOG.info("Jetty Server starting on host: {}:{}", (Object)connector.getHost(), (Object)connector.getPort());
                connectorRef.memoryStore.start();
                connectorRef.server.start();
                CONNECTORS.put(connectorKey, connectorRef);
            } else {
                connectorRef.increment();
            }
            if (endpoint.isSessionSupport()) {
                this.enableSessionSupport(connectorRef.server, connectorKey);
            }
            DefaultNodeSynchronization sync = new DefaultNodeSynchronization(connectorRef.memoryStore);
            WebsocketComponentServlet servlet = this.addServlet(sync, prodcon, endpoint.getResourceUri());
            if (prodcon instanceof WebsocketConsumer) {
                WebsocketConsumer consumer = (WebsocketConsumer)WebsocketConsumer.class.cast(prodcon);
                if (servlet.getConsumer() == null) {
                    servlet.setConsumer(consumer);
                }
                servlet.connect(consumer);
            }
            if (prodcon instanceof WebsocketProducer) {
                WebsocketProducer producer = (WebsocketProducer)WebsocketProducer.class.cast(prodcon);
                producer.setStore(connectorRef.memoryStore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(WebsocketProducerConsumer prodcon) throws Exception {
        WebsocketEndpoint endpoint = prodcon.getEndpoint();
        String connectorKey = WebsocketComponent.getConnectorKey(endpoint);
        HashMap<String, ConnectorRef> hashMap = CONNECTORS;
        synchronized (hashMap) {
            ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
            if (connectorRef != null) {
                if (connectorRef.decrement() == 0) {
                    LOG.info("Stopping Jetty Server as the last connector is disconnecting: {}:{}", (Object)connectorRef.connector.getHost(), (Object)connectorRef.connector.getPort());
                    this.servlets.remove(WebsocketComponent.createPathSpec(endpoint.getResourceUri()));
                    connectorRef.server.removeConnector((Connector)connectorRef.connector);
                    if (connectorRef.connector != null) {
                        connectorRef.connector.stop();
                    }
                    connectorRef.server.stop();
                    connectorRef.memoryStore.stop();
                    CONNECTORS.remove(connectorKey);
                    if (this.mbContainer != null) {
                        this.mbContainer.beanRemoved(null, (Object)connectorRef.server);
                        this.mbContainer.beanRemoved(null, (Object)connectorRef.connector);
                    }
                }
                if (prodcon instanceof WebsocketConsumer) {
                    connectorRef.servlet.disconnect((WebsocketConsumer)prodcon);
                }
                if (prodcon instanceof WebsocketProducer) {
                    ((WebsocketProducer)prodcon).setStore(null);
                }
            }
        }
    }

    public synchronized MBeanContainer getMbContainer() {
        if (this.mbContainer == null) {
            this.mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        }
        return this.mbContainer;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SSLContextParameters sslContextParameters = (SSLContextParameters)this.resolveAndRemoveReferenceParameter(parameters, "sslContextParameters", SSLContextParameters.class);
        Boolean enableJmx = (Boolean)this.getAndRemoveParameter(parameters, "enableJmx", Boolean.class);
        String staticResources = (String)this.getAndRemoveParameter(parameters, "staticResources", String.class);
        int port = this.extractPortNumber(remaining);
        String host = this.extractHostName(remaining);
        WebsocketEndpoint endpoint = this.newEndpoint(uri, remaining);
        if (enableJmx != null) {
            endpoint.setEnableJmx(enableJmx);
        } else {
            endpoint.setEnableJmx(this.isEnableJmx());
        }
        if (sslContextParameters == null) {
            sslContextParameters = this.getSslContextParameters();
        }
        if (sslContextParameters == null) {
            sslContextParameters = this.retrieveGlobalSslContextParameters();
        }
        if (staticResources == null) {
            staticResources = this.getStaticResources();
        }
        if (staticResources != null) {
            endpoint.setStaticResources(staticResources);
        }
        endpoint.setSslContextParameters(sslContextParameters);
        endpoint.setPort(port);
        endpoint.setHost(host);
        endpoint.setSubprotocol(this.subprotocol);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected WebsocketEndpoint newEndpoint(String uri, String remaining) {
        return new WebsocketEndpoint(this, uri, remaining);
    }

    protected void setWebSocketComponentServletInitialParameter(ServletContextHandler context, WebsocketEndpoint endpoint) {
        if (endpoint.getBufferSize() != null) {
            context.setInitParameter("bufferSize", endpoint.getBufferSize().toString());
        }
        if (endpoint.getMaxIdleTime() != null) {
            context.setInitParameter("maxIdleTime", endpoint.getMaxIdleTime().toString());
        }
        if (endpoint.getMaxTextMessageSize() != null) {
            context.setInitParameter("maxTextMessageSize", endpoint.getMaxTextMessageSize().toString());
        }
        if (endpoint.getMaxBinaryMessageSize() != null) {
            context.setInitParameter("maxBinaryMessageSize", endpoint.getMaxBinaryMessageSize().toString());
        }
        if (endpoint.getMinVersion() != null) {
            context.setInitParameter("minVersion", endpoint.getMinVersion().toString());
        }
    }

    protected Server createServer() throws Exception {
        Server server = null;
        if (this.minThreads == null && this.maxThreads == null && this.getThreadPool() == null) {
            this.minThreads = 1;
            this.maxThreads = 1 + Runtime.getRuntime().availableProcessors() * 2;
        }
        if (this.minThreads != null || this.maxThreads != null) {
            if (this.getThreadPool() != null) {
                throw new IllegalArgumentException("You cannot configure both minThreads/maxThreads and a custom threadPool on JettyHttpComponent: " + this);
            }
            QueuedThreadPool qtp = new QueuedThreadPool();
            if (this.minThreads != null) {
                qtp.setMinThreads(this.minThreads.intValue());
            }
            if (this.maxThreads != null) {
                qtp.setMaxThreads(this.maxThreads.intValue());
            }
            qtp.setName("CamelJettyWebSocketServer");
            try {
                qtp.start();
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error starting JettyWebSocketServer thread pool: " + qtp, (Throwable)e);
            }
            server = new Server((ThreadPool)qtp);
            ContextHandlerCollection collection = new ContextHandlerCollection();
            server.setHandler((Handler)collection);
        }
        if (this.getThreadPool() != null) {
            server = new Server(this.getThreadPool());
            ContextHandlerCollection collection = new ContextHandlerCollection();
            server.setHandler((Handler)collection);
        }
        return server;
    }

    protected Server createStaticResourcesServer(Server server, ServletContextHandler context, String home) throws Exception {
        context.setContextPath("/");
        SessionHandler sh = new SessionHandler();
        context.setSessionHandler(sh);
        if (home != null) {
            String[] resources = home.split(":");
            if (LOG.isDebugEnabled()) {
                LOG.debug(">>> Protocol found: {}, and resource: {}", (Object)resources[0], (Object)resources[1]);
            }
            if (resources[0].equals("classpath")) {
                context.setBaseResource((Resource)new JettyClassPathResource(this.getCamelContext().getClassResolver(), resources[1]));
            } else if (resources[0].equals("file")) {
                context.setBaseResource(Resource.newResource((String)resources[1]));
            }
            DefaultServlet defaultServlet = new DefaultServlet();
            ServletHolder holder = new ServletHolder((Servlet)defaultServlet);
            holder.setInitParameter("useFileMappedBuffer", "false");
            context.addServlet(holder, "/");
        }
        server.setHandler((Handler)context);
        return server;
    }

    protected Server createStaticResourcesServer(ServletContextHandler context, String host, int port, String home) throws Exception {
        Server server = new Server();
        HttpConfiguration httpConfig = new HttpConfiguration();
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        connector.setHost(host);
        connector.setPort(port);
        server.addConnector((Connector)connector);
        return this.createStaticResourcesServer(server, context, home);
    }

    protected WebsocketComponentServlet addServlet(NodeSynchronization sync, WebsocketProducerConsumer prodcon, String resourceUri) throws Exception {
        WebsocketEndpoint endpoint = prodcon.getEndpoint();
        String key = WebsocketComponent.getConnectorKey(endpoint);
        ConnectorRef connectorRef = WebsocketComponent.getConnectors().get(key);
        if (connectorRef != null) {
            String pathSpec = WebsocketComponent.createPathSpec(resourceUri);
            WebsocketComponentServlet servlet = this.servlets.get(pathSpec);
            if (servlet == null) {
                ServletContextHandler context = (ServletContextHandler)connectorRef.server.getHandler();
                connectorRef.servlet = servlet = this.createServlet(sync, pathSpec, this.servlets, context);
                LOG.debug("WebSocket servlet added for the following path : {}, to the Jetty Server : {}", (Object)pathSpec, (Object)key);
            }
            return servlet;
        }
        throw new Exception("Jetty instance has not been retrieved for : " + key);
    }

    protected WebsocketComponentServlet createServlet(NodeSynchronization sync, String pathSpec, Map<String, WebsocketComponentServlet> servlets, ServletContextHandler handler) {
        WebsocketComponentServlet servlet = new WebsocketComponentServlet(sync, pathSpec, this.socketFactory);
        servlets.put(pathSpec, servlet);
        ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
        servletHolder.getInitParameters().putAll(handler.getInitParams());
        servletHolder.setInitParameter("inputBufferSize", handler.getInitParameter("bufferSize"));
        handler.addServlet(servletHolder, pathSpec);
        return servlet;
    }

    protected ServletContextHandler createContext(Server server, Connector connector, List<Handler> handlers) {
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/", 0);
        server.addConnector(connector);
        if (handlers != null && !handlers.isEmpty()) {
            for (Handler handler : handlers) {
                if (handler instanceof HandlerWrapper) {
                    ((HandlerWrapper)handler).setHandler(server.getHandler());
                    server.setHandler(handler);
                    continue;
                }
                HandlerCollection handlerCollection = new HandlerCollection();
                handlerCollection.addHandler(server.getHandler());
                handlerCollection.addHandler(handler);
                server.setHandler((Handler)handlerCollection);
            }
        }
        return context;
    }

    private void enableSessionSupport(Server server, String connectorKey) throws Exception {
        ServletContextHandler context = (ServletContextHandler)server.getChildHandlerByClass(ServletContextHandler.class);
        if (context.getSessionHandler() == null) {
            SessionHandler sessionHandler = new SessionHandler();
            if (context.isStarted()) {
                throw new IllegalStateException("Server has already been started. Cannot enabled sessionSupport on " + connectorKey);
            }
            context.setSessionHandler(sessionHandler);
        }
    }

    private ServerConnector getSslSocketConnector(Server server, SSLContextParameters sslContextParameters) throws Exception {
        ServerConnector sslSocketConnector = null;
        if (sslContextParameters != null) {
            WebSocketComponentSslContextFactory sslContextFactory = new WebSocketComponentSslContextFactory();
            sslContextFactory.setEndpointIdentificationAlgorithm(null);
            sslContextFactory.setSslContext(sslContextParameters.createSSLContext(this.getCamelContext()));
            sslSocketConnector = new ServerConnector(server, (SslContextFactory)sslContextFactory);
        } else {
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setEndpointIdentificationAlgorithm(null);
            sslContextFactory.setKeyStorePassword(this.sslKeyPassword);
            sslContextFactory.setKeyManagerPassword(this.sslPassword);
            if (this.sslKeystore != null) {
                sslContextFactory.setKeyStorePath(this.sslKeystore);
            }
            sslSocketConnector = new ServerConnector(server, sslContextFactory);
        }
        return sslSocketConnector;
    }

    private static boolean checkSSLContextFactoryConfig(Object instance) {
        try {
            Method method = instance.getClass().getMethod("checkConfig", new Class[0]);
            return (Boolean)method.invoke(instance, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    public static String createPathSpec(String remaining) {
        int index = remaining.indexOf(47);
        if (index != -1) {
            return remaining.substring(index, remaining.length());
        }
        return "/" + remaining;
    }

    private int extractPortNumber(String remaining) {
        int index1 = remaining.indexOf(58);
        int index2 = remaining.indexOf(47);
        if (index1 != -1 && index2 != -1) {
            String result = remaining.substring(index1 + 1, index2);
            return Integer.parseInt(result);
        }
        return this.port;
    }

    private String extractHostName(String remaining) {
        int index = remaining.indexOf(58);
        if (index != -1) {
            return remaining.substring(0, index);
        }
        return this.host;
    }

    private static String getConnectorKey(WebsocketEndpoint endpoint) {
        return endpoint.getProtocol() + ":" + endpoint.getHost() + ":" + endpoint.getPort();
    }

    private void enableJmx(Server server) {
        MBeanContainer containerToRegister = this.getMbContainer();
        if (containerToRegister != null) {
            LOG.info("Jetty JMX Extensions is enabled");
            server.addEventListener((Container.Listener)containerToRegister);
        }
    }

    private void applyCrossOriginFiltering(WebsocketEndpoint endpoint, ServletContextHandler context) {
        if (endpoint.isCrossOriginFilterOn()) {
            FilterHolder filterHolder = new FilterHolder();
            CrossOriginFilter filter = new CrossOriginFilter();
            filterHolder.setFilter((Filter)filter);
            filterHolder.setInitParameter("allowedOrigins", endpoint.getAllowedOrigins());
            context.addFilter(filterHolder, endpoint.getFilterPath(), EnumSet.allOf(DispatcherType.class));
        }
    }

    public String getStaticResources() {
        return this.staticResources;
    }

    public void setStaticResources(String staticResources) {
        this.staticResources = staticResources;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public String getSslPassword() {
        return this.sslPassword;
    }

    public String getSslKeystore() {
        return this.sslKeystore;
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public void setSslPassword(String sslPassword) {
        this.sslPassword = sslPassword;
    }

    public void setSslKeystore(String sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public Integer getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(Integer minThreads) {
        this.minThreads = minThreads;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public String getSubprotocol() {
        return this.subprotocol;
    }

    public void setSubprotocol(String subprotocol) {
        this.subprotocol = subprotocol;
    }

    public Map<String, WebSocketFactory> getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(Map<String, WebSocketFactory> socketFactory) {
        this.socketFactory = socketFactory;
        if (!this.socketFactory.containsKey("default")) {
            this.socketFactory.put("default", new DefaultWebsocketFactory());
        }
    }

    public static HashMap<String, ConnectorRef> getConnectors() {
        return CONNECTORS;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.staticResources != null) {
            StringHelper.notEmpty((String)this.host, (String)"host", (Object)((Object)this));
            ObjectHelper.notNull((Object)this.port, (String)"port", (Object)((Object)this));
            LOG.info("Starting static resources server {}:{} with static resource: {}", new Object[]{this.host, this.port, this.staticResources});
            ServletContextHandler context = new ServletContextHandler(1);
            this.staticResourcesServer = this.createStaticResourcesServer(context, this.host, this.port, this.staticResources);
            this.staticResourcesServer.start();
            ServerConnector connector = (ServerConnector)this.staticResourcesServer.getConnectors()[0];
            MemoryWebsocketStore memoryStore = new MemoryWebsocketStore();
            ConnectorRef ref = new ConnectorRef(this.staticResourcesServer, connector, null, memoryStore);
            String key = "websocket:" + this.host + ":" + this.port;
            CONNECTORS.put(key, ref);
        }
    }

    public void doStop() throws Exception {
        super.doStop();
        if (CONNECTORS.size() > 0) {
            for (String connectorKey : CONNECTORS.keySet()) {
                ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
                if (connectorRef != null && connectorRef.getRefCount() == 0) {
                    connectorRef.server.removeConnector((Connector)connectorRef.connector);
                    connectorRef.connector.stop();
                    connectorRef.server.stop();
                    connectorRef.memoryStore.stop();
                    connectorRef.servlet = null;
                }
                CONNECTORS.remove(connectorKey);
            }
        }
        CONNECTORS.clear();
        if (this.staticResourcesServer != null) {
            LOG.info("Stopping static resources server {}:{} with static resource: {}", new Object[]{this.host, this.port, this.staticResources});
            this.staticResourcesServer.stop();
            this.staticResourcesServer.destroy();
            this.staticResourcesServer = null;
        }
        this.servlets.clear();
    }

    private static final class WebSocketComponentSslContextFactory
    extends SslContextFactory {
        private WebSocketComponentSslContextFactory() {
        }

        public boolean checkConfig() {
            if (this.getSslContext() == null) {
                return WebsocketComponent.checkSSLContextFactoryConfig((Object)this);
            }
            return true;
        }
    }

    static class ConnectorRef {
        Server server;
        ServerConnector connector;
        WebsocketComponentServlet servlet;
        MemoryWebsocketStore memoryStore;
        int refCount;

        ConnectorRef(Server server, ServerConnector connector, WebsocketComponentServlet servlet, MemoryWebsocketStore memoryStore) {
            this.server = server;
            this.connector = connector;
            this.servlet = servlet;
            this.memoryStore = memoryStore;
            this.increment();
        }

        public int increment() {
            return ++this.refCount;
        }

        public int decrement() {
            return --this.refCount;
        }

        public int getRefCount() {
            return this.refCount;
        }
    }
}

