/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.web3j;

import org.apache.camel.spi.Metadata;

public interface Web3jConstants {
    public static final String WEB3_CLIENT_VERSION = "WEB3_CLIENT_VERSION";
    public static final String WEB3_SHA3 = "WEB3_SHA3";
    public static final String NET_VERSION = "NET_VERSION";
    public static final String NET_LISTENING = "NET_LISTENING";
    public static final String NET_PEER_COUNT = "NET_PEER_COUNT";
    public static final String ETH_PROTOCOL_VERSION = "ethProtocolVersion";
    public static final String ETH_COINBASE = "ETH_COINBASE";
    public static final String ETH_SYNCING = "ETH_SYNCING";
    public static final String ETH_MINING = "ETH_MINING";
    @Metadata(label="producer", description="A hexadecimal string representation (32 bytes) of the hash rate.", javaType="String")
    public static final String ETH_HASHRATE = "ETH_HASHRATE";
    public static final String ETH_GAS_PRICE = "ETH_GAS_PRICE";
    public static final String ETH_ACCOUNTS = "ETH_ACCOUNTS";
    public static final String ETH_BLOCK_NUMBER = "ETH_BLOCK_NUMBER";
    public static final String ETH_GET_BALANCE = "ETH_GET_BALANCE";
    public static final String ETH_GET_STORAGE_AT = "ETH_GET_STORAGE_AT";
    public static final String ETH_GET_TRANSACTION_COUNT = "ETH_GET_TRANSACTION_COUNT";
    public static final String ETH_GET_BLOCK_TRANSACTION_COUNT_BY_HASH = "ETH_GET_BLOCK_TRANSACTION_COUNT_BY_HASH";
    public static final String ETH_GET_BLOCK_TRANSACTION_COUNT_BY_NUMBER = "ETH_GET_BLOCK_TRANSACTION_COUNT_BY_NUMBER";
    public static final String ETH_GET_UNCLE_COUNT_BY_BLOCK_HASH = "ETH_GET_UNCLE_COUNT_BY_BLOCK_HASH";
    public static final String ETH_GET_UNCLE_COUNT_BY_BLOCK_NUMBER = "ETH_GET_UNCLE_COUNT_BY_BLOCK_NUMBER";
    public static final String ETH_GET_CODE = "ETH_GET_CODE";
    public static final String ETH_SIGN = "ETH_SIGN";
    public static final String ETH_SEND_TRANSACTION = "ETH_SEND_TRANSACTION";
    public static final String ETH_SEND_RAW_TRANSACTION = "ETH_SEND_RAW_TRANSACTION";
    public static final String ETH_CALL = "ETH_CALL";
    public static final String ETH_ESTIMATE_GAS = "ETH_ESTIMATE_GAS";
    public static final String ETH_GET_BLOCK_BY_HASH = "ETH_GET_BLOCK_BY_HASH";
    public static final String ETH_GET_BLOCK_BY_NUMBER = "ETH_GET_BLOCK_BY_NUMBER";
    public static final String ETH_GET_TRANSACTION_BY_HASH = "ETH_GET_TRANSACTION_BY_HASH";
    public static final String ETH_GET_TRANSACTION_BY_BLOCK_HASH_AND_INDEX = "ETH_GET_TRANSACTION_BY_BLOCK_HASH_AND_INDEX";
    public static final String ETH_GET_TRANSACTION_BY_BLOCK_NUMBER_AND_INDEX = "ETH_GET_TRANSACTION_BY_BLOCK_NUMBER_AND_INDEX";
    public static final String ETH_GET_TRANSACTION_RECEIPT = "ETH_GET_TRANSACTION_RECEIPT";
    public static final String ETH_GET_UNCLE_BY_BLOCK_HASH_AND_INDEX = "ETH_GET_UNCLE_BY_BLOCK_HASH_AND_INDEX";
    public static final String ETH_GET_UNCLE_BY_BLOCK_NUMBER_AND_INDEX = "ETH_GET_UNCLE_BY_BLOCK_NUMBER_AND_INDEX";
    public static final String ETH_GET_COMPILERS = "ETH_GET_COMPILERS";
    public static final String ETH_COMPILE_LLL = "ETH_COMPILE_LLL";
    public static final String ETH_COMPILE_SOLIDITY = "ETH_COMPILE_SOLIDITY";
    public static final String ETH_COMPILE_SERPENT = "ETH_COMPILE_SERPENT";
    public static final String ETH_NEW_FILTER = "ETH_NEW_FILTER";
    public static final String ETH_NEW_BLOCK_FILTER = "ETH_NEW_BLOCK_FILTER";
    public static final String ETH_NEW_PENDING_TRANSACTION_FILTER = "ETH_NEW_PENDING_TRANSACTION_FILTER";
    public static final String ETH_UNINSTALL_FILTER = "ETH_UNINSTALL_FILTER";
    public static final String ETH_GET_FILTER_CHANGES = "ETH_GET_FILTER_CHANGES";
    public static final String ETH_GET_FILTER_LOGS = "ETH_GET_FILTER_LOGS";
    public static final String ETH_GET_LOGS = "ETH_GET_LOGS";
    public static final String ETH_GET_WORK = "ETH_GET_WORK";
    public static final String ETH_SUBMIT_WORK = "ETH_SUBMIT_WORK";
    public static final String ETH_SUBMIT_HASHRATE = "ETH_SUBMIT_HASHRATE";
    public static final String DB_PUT_STRING = "DB_PUT_STRING";
    public static final String DB_GET_STRING = "DB_GET_STRING";
    public static final String DB_PUT_HEX = "DB_PUT_HEX";
    public static final String DB_GET_HEX = "DB_GET_HEX";
    public static final String SHH_VERSION = "SHH_VERSION";
    public static final String SHH_POST = "SHH_POST";
    public static final String SHH_NEW_IDENTITY = "SHH_NEW_IDENTITY";
    public static final String SHH_HAS_IDENTITY = "SHH_HAS_IDENTITY";
    public static final String SHH_NEW_GROUP = "SHH_NEW_GROUP";
    public static final String SHH_ADD_TO_GROUP = "SHH_ADD_TO_GROUP";
    public static final String SHH_NEW_FILTER = "SHH_NEW_FILTER";
    public static final String SHH_UNINSTALL_FILTER = "SHH_UNINSTALL_FILTER";
    public static final String SHH_GET_FILTER_CHANGES = "SHH_GET_FILTER_CHANGES";
    public static final String SHH_GET_MESSAGES = "SHH_GET_MESSAGES";
    public static final String QUORUM_ETH_SEND_TRANSACTION = "QUORUM_ETH_SEND_TRANSACTION";
    public static final String QUORUM_NODE_INFO = "QUORUM_NODE_INFO";
    public static final String QUORUM_GET_PRIVATE_PAYLOAD = "QUORUM_GET_PRIVATE_PAYLOAD";
    public static final String ETH_LOG_OBSERVABLE = "ETH_LOG_OBSERVABLE";
    public static final String ETH_BLOCK_HASH_OBSERVABLE = "ETH_BLOCK_HASH_OBSERVABLE";
    public static final String ETH_PENDING_TRANSACTION_HASH_OBSERVABLE = "ETH_PENDING_TRANSACTION_HASH_OBSERVABLE";
    public static final String TRANSACTION_OBSERVABLE = "TRANSACTION_OBSERVABLE";
    public static final String PENDING_TRANSACTION_OBSERVABLE = "PENDING_TRANSACTION_OBSERVABLE";
    public static final String BLOCK_OBSERVABLE = "BLOCK_OBSERVABLE";
    public static final String REPLAY_BLOCKS_OBSERVABLE = "REPLAY_BLOCKS_OBSERVABLE";
    public static final String REPLAY_TRANSACTIONS_OBSERVABLE = "REPLAY_TRANSACTIONS_OBSERVABLE";
    @Metadata(label="producer", description="The id", javaType="Long")
    public static final String ID = "ID";
    public static final String OPERATION = "OPERATION";
    public static final String TRANSACTION = "TRANSACTION";
    @Metadata(label="producer", javaType="String")
    public static final String AT_BLOCK = "AT_BLOCK";
    @Metadata(label="producer", description="Contract address.", javaType="String")
    public static final String ADDRESS = "ADDRESS";
    @Metadata(label="producer", description="Contract address or a list of addresses.", javaType="List<String>")
    public static final String ADDRESSES = "ADDRESSES";
    @Metadata(label="producer", description="The address the transaction is send from", javaType="String")
    public static final String FROM_ADDRESS = "FROM_ADDRESS";
    @Metadata(label="producer", description="The address the transaction is directed to", javaType="String")
    public static final String TO_ADDRESS = "TO_ADDRESS";
    @Metadata(label="producer", description="The transaction index position withing a block.", javaType="String")
    public static final String POSITION = "POSITION";
    @Metadata(label="producer", description="Hash of the block where this transaction was in.", javaType="String")
    public static final String BLOCK_HASH = "BLOCK_HASH";
    @Metadata(label="producer", description="The information about a transaction requested by transaction hash.", javaType="String")
    public static final String TRANSACTION_HASH = "TRANSACTION_HASH";
    @Metadata(label="producer", description="Message to sign by calculating an Ethereum specific signature.", javaType="String")
    public static final String SHA3_HASH_OF_DATA_TO_SIGN = "SHA3_HASH_OF_DATA_TO_SIGN";
    @Metadata(label="producer", description="The signed transaction data for a new message call transaction or a contract creation for signed transactions.", javaType="String")
    public static final String SIGNED_TRANSACTION_DATA = "SIGNED_TRANSACTION_DATA";
    @Metadata(label="producer", description="If true it returns the full transaction objects, if false only the hashes of the transactions.", javaType="Boolean")
    public static final String FULL_TRANSACTION_OBJECTS = "FULL_TRANSACTION_OBJECTS";
    @Metadata(label="producer", description="The transactions/uncle index position in the block.", javaType="String")
    public static final String INDEX = "INDEX";
    @Metadata(label="producer", description="The source code to compile.", javaType="String")
    public static final String SOURCE_CODE = "SOURCE_CODE";
    @Metadata(label="producer", description="The filter id to use.", javaType="java.math.BigInteger")
    public static final String FILTER_ID = "FILTER_ID";
    @Metadata(label="producer", description="The local database name.", javaType="String")
    public static final String DATABASE_NAME = "DATABASE_NAME";
    @Metadata(label="producer", description="The key name in the database.", javaType="String")
    public static final String KEY_NAME = "KEY_NAME";
    @Metadata(label="producer", description="The nonce found (64 bits) used for submitting a proof-of-work solution.", javaType="java.math.BigInteger")
    public static final String NONCE = "NONCE";
    @Metadata(label="producer", description="The header's pow-hash (256 bits) used for submitting a proof-of-work solution.", javaType="String")
    public static final String HEADER_POW_HASH = "HEADER_POW_HASH";
    @Metadata(label="producer", description="The mix digest (256 bits) used for submitting a proof-of-work solution.", javaType="String")
    public static final String MIX_DIGEST = "MIX_DIGEST";
    @Metadata(label="producer", description="A random hexadecimal(32 bytes) ID identifying the client.", javaType="String")
    public static final String CLIENT_ID = "CLIENT_ID";
    @Metadata(label="producer", description="Gas price used for each paid gas.", javaType="java.math.BigInteger")
    public static final String GAS_PRICE = "GAS_PRICE";
    @Metadata(label="producer", description="The maximum gas allowed in this block.", javaType="java.math.BigInteger")
    public static final String GAS_LIMIT = "GAS_LIMIT";
    @Metadata(label="producer", description="The value sent within a transaction.", javaType="java.math.BigInteger")
    public static final String VALUE = "VALUE";
    @Metadata(label="producer", description="The compiled code of a contract OR the hash of the invoked method signature and encoded parameters.", javaType="String")
    public static final String DATA = "DATA";
    @Metadata(label="producer", javaType="String")
    public static final String FROM_BLOCK = "FROM_BLOCK";
    @Metadata(label="producer", javaType="String")
    public static final String TO_BLOCK = "TO_BLOCK";
    @Metadata(label="producer", description="Topics are order-dependent. Each topic can also be a list of topics. Specify multiple topics separated by comma.", javaType="List<String>")
    public static final String TOPICS = "TOPICS";
    @Metadata(label="producer", description="The priority of a whisper message.", javaType="java.math.BigInteger")
    public static final String PRIORITY = "PRIORITY";
    @Metadata(label="producer", description="The time to live in seconds of a whisper message.", javaType="java.math.BigInteger")
    public static final String TTL = "TTL";
    @Metadata(label="producer", description="A transaction privateFor nodes with public keys in a Quorum network", javaType="List<String>")
    public static final String PRIVATE_FOR = "PRIVATE_FOR";
    @Metadata(label="producer", description="A transaction privateFrom", javaType="String")
    public static final String PRIVATE_FROM = "PRIVATE_FROM";
    @Metadata(label="producer", description="The error code", javaType="int")
    public static final String ERROR_CODE = "ERROR_CODE";
    @Metadata(label="producer", description="The error data", javaType="String")
    public static final String ERROR_DATA = "ERROR_DATA";
    @Metadata(label="producer", description="The error message", javaType="String")
    public static final String ERROR_MESSAGE = "ERROR_MESSAGE";
    @Metadata(label="consumer", description="The status of the operation", javaType="String")
    public static final String HEADER_STATUS = "status";
    @Metadata(label="consumer", description="The operation", javaType="String")
    public static final String HEADER_OPERATION = "operation";
}

