/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weather;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.weather.WeatherComponent;
import org.apache.camel.component.weather.WeatherEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class WeatherProducer
extends DefaultProducer {
    private final String query;

    public WeatherProducer(WeatherEndpoint endpoint, String query) {
        super((Endpoint)endpoint);
        this.query = query;
    }

    public WeatherEndpoint getEndpoint() {
        return (WeatherEndpoint)super.getEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        String q = this.query;
        String location = (String)exchange.getIn().getHeader("CamelWeatherLocation", String.class);
        if (location != null) {
            q = this.getEndpoint().getConfiguration().getQuery(location);
        }
        HttpClient httpClient = ((WeatherComponent)this.getEndpoint().getComponent()).getHttpClient();
        GetMethod method = new GetMethod(q);
        try {
            this.log.debug("Going to execute the Weather query {}", (Object)q);
            int statusCode = httpClient.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                throw new IllegalStateException("Got the invalid http status value '" + method.getStatusLine() + "' as the result of the query '" + this.query + "'");
            }
            String weather = (String)this.getEndpoint().getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, (Object)method.getResponseBodyAsStream());
            this.log.debug("Got back the Weather information {}", (Object)weather);
            if (ObjectHelper.isEmpty((Object)weather)) {
                throw new IllegalStateException("Got the unexpected value '" + weather + "' as the result of the query '" + q + "'");
            }
            String header = this.getEndpoint().getConfiguration().getHeaderName();
            if (header != null) {
                exchange.getIn().setHeader(header, (Object)weather);
            } else {
                exchange.getIn().setBody((Object)weather);
            }
            exchange.getIn().setHeader("CamelWeatherQuery", (Object)q);
        }
        finally {
            method.releaseConnection();
        }
    }
}

