/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.wasm;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.language.wasm.WasmExpression;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.TypedLanguageSupport;
import org.apache.camel.support.component.PropertyConfigurerSupport;

@Language(value="wasm")
public class WasmLanguage
extends TypedLanguageSupport
implements PropertyConfigurer {
    private String module;

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
        if (target != this) {
            throw new IllegalStateException("Can only configure our own instance !");
        }
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "module": {
                this.setModule((String)PropertyConfigurerSupport.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate((Expression)this.createExpression(expression));
    }

    public Expression createExpression(String expression) {
        return this.createExpression(expression, null);
    }

    public Predicate createPredicate(String expression, Object[] properties) {
        return ExpressionToPredicateAdapter.toPredicate((Expression)this.createExpression(expression, properties));
    }

    public Expression createExpression(String expression, Object[] properties) {
        WasmExpression answer = new WasmExpression(expression);
        answer.setResultType((Class)this.property(Class.class, properties, 0, null));
        answer.setModule((String)this.property(String.class, properties, 1, this.getModule()));
        if (this.getCamelContext() != null) {
            answer.init(this.getCamelContext());
        }
        return answer;
    }
}

