/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.wasm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;

public final class WasmSupport {
    public static final ObjectMapper MAPPER = JsonMapper.builder().build();

    private WasmSupport() {
    }

    public static byte[] serialize(Exchange exchange) throws Exception {
        Wrapper env = new Wrapper();
        env.body = (byte[])exchange.getMessage().getBody(byte[].class);
        for (String headerName : exchange.getMessage().getHeaders().keySet()) {
            env.headers.put(headerName, (String)exchange.getMessage().getHeader(headerName, String.class));
        }
        return MAPPER.writeValueAsBytes((Object)env);
    }

    public static void deserialize(byte[] in, Exchange out) throws Exception {
        out.getMessage().getHeaders().clear();
        out.getMessage().setBody(null);
        Wrapper w = (Wrapper)MAPPER.readValue(in, Wrapper.class);
        out.getMessage().setBody((Object)w.body);
        if (w.headers != null) {
            out.getMessage().setHeaders(w.headers);
        }
    }

    public static class Wrapper {
        @JsonProperty
        public Map<String, String> headers = new HashMap<String, String>();
        @JsonProperty
        public byte[] body;
    }
}

