/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.camel.component.wal.LogEntry;
import org.apache.camel.component.wal.exceptions.BufferOverflow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class IOUtil {
    private static final Logger LOG = LoggerFactory.getLogger(IOUtil.class);

    private IOUtil() {
    }

    static long write(FileChannel fileChannel, ByteBuffer byteBuffer, long position) throws IOException {
        long bytesWritten = 0L;
        byteBuffer.flip();
        while (byteBuffer.hasRemaining()) {
            bytesWritten += (long)fileChannel.write(byteBuffer, position + bytesWritten);
        }
        byteBuffer.flip();
        byteBuffer.clear();
        return bytesWritten;
    }

    static long write(FileChannel fileChannel, ByteBuffer byteBuffer) throws IOException {
        long bytesWritten = 0L;
        byteBuffer.flip();
        while (byteBuffer.hasRemaining()) {
            bytesWritten += (long)fileChannel.write(byteBuffer);
        }
        byteBuffer.flip();
        byteBuffer.clear();
        return bytesWritten;
    }

    static void serialize(ByteBuffer buffer, LogEntry entry) throws BufferOverflow {
        IOUtil.serialize(buffer, entry.getEntryState().getCode(), entry.getKeyMetadata(), entry.getKey(), entry.getValueMetadata(), entry.getValue());
    }

    static void serialize(ByteBuffer buffer, int entryState, int keyMetadata, byte[] key, int valueMetadata, byte[] value) throws BufferOverflow {
        IOUtil.checkBufferCapacity(buffer, 8 + key.length + 4 + 4 + value.length);
        buffer.putInt(entryState);
        buffer.putInt(keyMetadata);
        buffer.putInt(key.length);
        buffer.put(key);
        buffer.putInt(valueMetadata);
        buffer.putInt(value.length);
        buffer.put(value);
    }

    private static void checkBufferCapacity(ByteBuffer byteBuffer, int requestedSize) throws BufferOverflow {
        int remaining = byteBuffer.remaining();
        if (remaining < requestedSize) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("There is not enough space on the buffer for an offset entry: {} bytes remaining, {} bytes needed", (Object)remaining, (Object)requestedSize);
            }
            throw new BufferOverflow(remaining, requestedSize);
        }
    }
}

