/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.vertx.VertxComponent;
import org.apache.camel.component.vertx.VertxConsumer;
import org.apache.camel.component.vertx.VertxProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.12.0", scheme="vertx", title="Vert.x", syntax="vertx:address", category={Category.EVENTBUS, Category.REACTIVE})
public class VertxEndpoint
extends DefaultEndpoint
implements AsyncEndpoint,
MultipleConsumersSupport {
    @UriPath
    @Metadata(required=true)
    private String address;
    @UriParam
    private Boolean pubSub;

    public VertxEndpoint(String uri, VertxComponent component, String address) {
        super(uri, (Component)component);
        this.address = address;
    }

    public VertxComponent getComponent() {
        return (VertxComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        return new VertxProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        VertxConsumer consumer = new VertxConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }

    public EventBus getEventBus() {
        if (this.getVertx() != null) {
            return this.getVertx().eventBus();
        }
        return null;
    }

    public Vertx getVertx() {
        return this.getComponent().getVertx();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean isPubSub() {
        return this.pubSub != null && this.pubSub != false;
    }

    public Boolean getPubSub() {
        return this.pubSub;
    }

    public void setPubSub(Boolean pubSub) {
        this.pubSub = pubSub;
    }
}

