/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.websocket;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.ext.web.Router;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.vertx.websocket.VertxWebsocketConfiguration;
import org.apache.camel.component.vertx.websocket.VertxWebsocketConsumer;
import org.apache.camel.component.vertx.websocket.VertxWebsocketEndpoint;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHelper;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHost;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHostConfiguration;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHostKey;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

@Component(value="vertx-websocket")
public class VertxWebsocketComponent
extends DefaultComponent
implements SSLContextParametersAware {
    private final Map<VertxWebsocketHostKey, VertxWebsocketHost> vertxHostRegistry = new ConcurrentHashMap<VertxWebsocketHostKey, VertxWebsocketHost>();
    private boolean managedVertx;
    @Metadata(label="advanced")
    private Vertx vertx;
    @Metadata(label="advanced")
    private VertxOptions vertxOptions;
    @Metadata(label="advanced")
    private Router router;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;
    @Metadata(label="advanced", defaultValue="0.0.0.0")
    private String defaultHost = "0.0.0.0";
    @Metadata(label="advanced", defaultValue="0")
    private int defaultPort = 0;
    @Metadata(label="advanced", defaultValue="true")
    private boolean allowOriginHeader = true;
    @Metadata(label="advanced")
    private String originHeaderUrl;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Object wsUri = remaining;
        if (((String)wsUri).matches("^wss?:.*")) {
            int schemeSeparatorIndex = remaining.indexOf(":");
            String scheme = remaining.substring(0, schemeSeparatorIndex);
            wsUri = scheme + "://" + ((String)wsUri).replaceFirst("wss?:/*", "");
        } else {
            String scheme = "ws://";
            wsUri = remaining.startsWith("/") ? scheme + "/" + remaining.replaceAll("^/+", "") : scheme + remaining;
        }
        URI endpointUri = new URI(UnsafeUriCharactersEncoder.encodeHttpURI((String)wsUri));
        URI websocketURI = URISupport.createRemainingURI((URI)endpointUri, parameters);
        if (websocketURI.getHost() == null || websocketURI.getPort() == -1 || ObjectHelper.isEmpty((String)websocketURI.getPath())) {
            String path = websocketURI.getPath();
            String host = websocketURI.getHost();
            int port = websocketURI.getPort();
            if (websocketURI.getHost() == null) {
                host = this.getDefaultHost();
            }
            if (websocketURI.getPort() == -1) {
                port = this.getDefaultPort();
            }
            if (ObjectHelper.isEmpty((String)path)) {
                path = "/";
            }
            websocketURI = new URI(websocketURI.getScheme(), websocketURI.getUserInfo(), host, port, path, websocketURI.getQuery(), websocketURI.getFragment());
        }
        VertxWebsocketConfiguration configuration = new VertxWebsocketConfiguration();
        configuration.setWebsocketURI(websocketURI);
        configuration.setAllowOriginHeader(this.isAllowOriginHeader());
        configuration.setOriginHeaderUrl(this.getOriginHeaderUrl());
        VertxWebsocketEndpoint endpoint = this.createEndpointInstance(uri, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (configuration.getSslContextParameters() == null) {
            configuration.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return endpoint;
    }

    protected VertxWebsocketEndpoint createEndpointInstance(String uri, VertxWebsocketConfiguration configuration) {
        return new VertxWebsocketEndpoint(uri, this, configuration);
    }

    protected void doInit() throws Exception {
        Set vertxes;
        if (this.vertx == null && (vertxes = this.getCamelContext().getRegistry().findByType(Vertx.class)).size() == 1) {
            this.vertx = (Vertx)vertxes.iterator().next();
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.vertx == null) {
            this.vertx = this.vertxOptions != null ? Vertx.vertx((VertxOptions)this.vertxOptions) : Vertx.vertx();
            this.managedVertx = true;
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.managedVertx && this.vertx != null) {
            this.vertx.close();
        }
        this.vertx = null;
    }

    public void connectConsumer(VertxWebsocketConsumer consumer) {
        VertxWebsocketEndpoint endpoint = consumer.getEndpoint();
        VertxWebsocketConfiguration configuration = endpoint.getConfiguration();
        VertxWebsocketHostKey hostKey = VertxWebsocketHelper.createHostKey(configuration.getWebsocketURI());
        VertxWebsocketHost host = this.vertxHostRegistry.computeIfAbsent(hostKey, key -> {
            Router vertxRouter = configuration.getRouter();
            if (vertxRouter == null) {
                Set routers;
                vertxRouter = this.router;
                if (vertxRouter == null && (routers = this.getCamelContext().getRegistry().findByType(Router.class)).size() == 1) {
                    vertxRouter = (Router)routers.iterator().next();
                }
                if (vertxRouter == null) {
                    vertxRouter = Router.router((Vertx)this.getVertx());
                }
            }
            VertxWebsocketHostConfiguration hostConfiguration = new VertxWebsocketHostConfiguration(this.getVertx(), vertxRouter, configuration.getServerOptions(), configuration.getSslContextParameters());
            return this.createVertxWebsocketHost(hostConfiguration, hostKey);
        });
        host.connect(consumer);
        try {
            host.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void disconnectConsumer(VertxWebsocketConsumer consumer) {
        VertxWebsocketEndpoint endpoint = consumer.getEndpoint();
        VertxWebsocketConfiguration configuration = endpoint.getConfiguration();
        VertxWebsocketHostKey hostKey = VertxWebsocketHelper.createHostKey(configuration.getWebsocketURI());
        VertxWebsocketHost vertxWebsocketHost = this.vertxHostRegistry.remove(hostKey);
        if (vertxWebsocketHost != null) {
            vertxWebsocketHost.disconnect(configuration.getWebsocketURI().getPath());
        }
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public VertxOptions getVertxOptions() {
        return this.vertxOptions;
    }

    public void setVertxOptions(VertxOptions vertxOptions) {
        this.vertxOptions = vertxOptions;
    }

    public Router getRouter() {
        return this.router;
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    protected Map<VertxWebsocketHostKey, VertxWebsocketHost> getVertxHostRegistry() {
        return this.vertxHostRegistry;
    }

    public boolean isAllowOriginHeader() {
        return this.allowOriginHeader;
    }

    public void setAllowOriginHeader(boolean allowOriginHeader) {
        this.allowOriginHeader = allowOriginHeader;
    }

    public String getOriginHeaderUrl() {
        return this.originHeaderUrl;
    }

    public void setOriginHeaderUrl(String originHeaderUrl) {
        this.originHeaderUrl = originHeaderUrl;
    }

    protected VertxWebsocketHost createVertxWebsocketHost(VertxWebsocketHostConfiguration hostConfiguration, VertxWebsocketHostKey hostKey) {
        return new VertxWebsocketHost(this.getCamelContext(), hostConfiguration, hostKey);
    }

    public void setDefaultHost(String defaultHost) {
        this.defaultHost = defaultHost;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public void setDefaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }
}

