/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.kafka.serde;

import io.vertx.core.buffer.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VertxKafkaHeaderSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(VertxKafkaHeaderSerializer.class);

    private VertxKafkaHeaderSerializer() {
    }

    public static Buffer serialize(Object value) {
        if (value instanceof String) {
            return Buffer.buffer((String)((String)value));
        }
        if (value instanceof Long) {
            return Buffer.buffer().appendLong(((Long)value).longValue());
        }
        if (value instanceof Integer) {
            return Buffer.buffer().appendInt(((Integer)value).intValue());
        }
        if (value instanceof Double) {
            return Buffer.buffer().appendDouble(((Double)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return Buffer.buffer((String)value.toString());
        }
        if (value instanceof Buffer) {
            return (Buffer)value;
        }
        if (value instanceof byte[]) {
            return Buffer.buffer((byte[])((byte[])value));
        }
        LOG.debug("Cannot propagate header value of type[{}], skipping... Supported types: String, Integer, Long, Double, byte[].", value != null ? value.getClass() : "null");
        return null;
    }
}

