/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.univocity;

import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.Writer;
import org.apache.camel.dataformat.univocity.AbstractUniVocityDataFormat;
import org.apache.camel.spi.annotations.Dataformat;

@Dataformat(value="univocityCsv")
public class UniVocityCsvDataFormat
extends AbstractUniVocityDataFormat<CsvFormat, CsvWriterSettings, CsvWriter, CsvParserSettings, CsvParser, UniVocityCsvDataFormat> {
    protected Boolean quoteAllFields;
    protected Character quote;
    protected Character quoteEscape;
    protected Character delimiter;

    public Boolean getQuoteAllFields() {
        return this.quoteAllFields;
    }

    public UniVocityCsvDataFormat setQuoteAllFields(Boolean quoteAllFields) {
        this.quoteAllFields = quoteAllFields;
        return this;
    }

    public Character getQuote() {
        return this.quote;
    }

    public UniVocityCsvDataFormat setQuote(Character quote) {
        this.quote = quote;
        return this;
    }

    public Character getQuoteEscape() {
        return this.quoteEscape;
    }

    public UniVocityCsvDataFormat setQuoteEscape(Character quoteEscape) {
        this.quoteEscape = quoteEscape;
        return this;
    }

    public Character getDelimiter() {
        return this.delimiter;
    }

    public UniVocityCsvDataFormat setDelimiter(Character delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    @Override
    protected CsvWriterSettings createWriterSettings() {
        return new CsvWriterSettings();
    }

    @Override
    protected void configureWriterSettings(CsvWriterSettings settings) {
        super.configureWriterSettings(settings);
        if (this.quoteAllFields != null) {
            settings.setQuoteAllFields(this.quoteAllFields.booleanValue());
        }
    }

    @Override
    protected CsvWriter createWriter(Writer writer, CsvWriterSettings settings) {
        return new CsvWriter(writer, settings);
    }

    @Override
    protected CsvParserSettings createParserSettings() {
        return new CsvParserSettings();
    }

    @Override
    protected void configureParserSettings(CsvParserSettings settings) {
        super.configureParserSettings(settings);
        if (this.emptyValue != null) {
            settings.setEmptyValue(this.emptyValue);
        }
    }

    @Override
    protected CsvParser createParser(CsvParserSettings settings) {
        return new CsvParser(settings);
    }

    @Override
    protected void configureFormat(CsvFormat format) {
        super.configureFormat(format);
        if (this.quote != null) {
            format.setQuote(this.quote.charValue());
        }
        if (this.quoteEscape != null) {
            format.setQuoteEscape(this.quoteEscape.charValue());
        }
        if (this.delimiter != null) {
            format.setDelimiter(this.delimiter.charValue());
        }
    }

    public String getDataFormatName() {
        return "univocityCsv";
    }
}

