/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.util;

import org.apache.camel.Converter;
import twitter4j.DirectMessage;
import twitter4j.Status;
import twitter4j.Trend;
import twitter4j.Trends;
import twitter4j.UserList;

@Converter(generateLoader=true)
public final class TwitterConverter {
    private TwitterConverter() {
    }

    @Converter
    public static String toString(Status status) {
        return status.getCreatedAt() + " (" + status.getUser().getScreenName() + ") " + status.getText();
    }

    @Converter
    public static String toString(DirectMessage dm) {
        return dm.getCreatedAt() + " (" + dm.getSenderId() + ") " + dm.getText();
    }

    @Converter
    public static String toString(Trend trend) {
        return trend.getName();
    }

    @Converter
    public static String toString(Trends trends) {
        StringBuilder s = new StringBuilder();
        s.append("(").append(trends.getTrendAt().toString()).append(") ");
        boolean first = true;
        for (Trend trend : trends.getTrends()) {
            if (first) {
                first = false;
            } else {
                s.append(",");
            }
            s.append(TwitterConverter.toString(trend));
        }
        return s.toString();
    }

    @Converter
    public static String toString(UserList userList) {
        return userList.getCreatedAt() + " (" + userList.getUser().getScreenName() + ") " + userList.getFullName() + "," + userList.getURI() + ",";
    }
}

