/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.timeline;

import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.twitter.AbstractTwitterEndpoint;
import org.apache.camel.component.twitter.TwitterConfiguration;
import org.apache.camel.component.twitter.TwitterHelper;
import org.apache.camel.component.twitter.data.TimelineType;
import org.apache.camel.component.twitter.timeline.AbstractStatusConsumerHandler;
import org.apache.camel.component.twitter.timeline.HomeConsumerHandler;
import org.apache.camel.component.twitter.timeline.MentionsConsumerHandler;
import org.apache.camel.component.twitter.timeline.RetweetsConsumerHandler;
import org.apache.camel.component.twitter.timeline.TwitterTimelineComponent;
import org.apache.camel.component.twitter.timeline.UserConsumerHandler;
import org.apache.camel.component.twitter.timeline.UserListConsumerHandler;
import org.apache.camel.component.twitter.timeline.UserProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(firstVersion="2.10.0", scheme="twitter-timeline", title="Twitter Timeline", syntax="twitter-timeline:timelineType", category={Category.API, Category.CLOUD, Category.SOCIAL})
public class TwitterTimelineEndpoint
extends AbstractTwitterEndpoint {
    @UriPath(description="The timeline type to produce/consume.")
    @Metadata(required=true)
    private TimelineType timelineType;
    @UriParam(description="The username when using timelineType=user")
    private String user;
    @UriParam(description="The list name when using timelineType=list")
    private String list;

    public TwitterTimelineEndpoint(String uri, String remaining, String user, String list, TwitterTimelineComponent component, TwitterConfiguration properties) {
        super(uri, component, properties);
        if (remaining == null) {
            throw new IllegalArgumentException(String.format("The timeline type must be specified for '%s'", uri));
        }
        this.timelineType = (TimelineType)((Object)component.getCamelContext().getTypeConverter().convertTo(TimelineType.class, (Object)remaining));
        this.user = user;
        this.list = list;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getList() {
        return this.list;
    }

    public void setList(String list) {
        this.list = list;
    }

    public Producer createProducer() throws Exception {
        if (this.timelineType != TimelineType.USER) {
            throw new IllegalArgumentException("Cannot create any producer with uri " + this.getEndpointUri() + ". A producer type was not provided (or an incorrect pairing was used).");
        }
        return new UserProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        AbstractStatusConsumerHandler handler = null;
        switch (this.timelineType) {
            case HOME: {
                handler = new HomeConsumerHandler(this);
                break;
            }
            case MENTIONS: {
                handler = new MentionsConsumerHandler(this);
                break;
            }
            case RETWEETSOFME: {
                handler = new RetweetsConsumerHandler(this);
                break;
            }
            case LIST: {
                handler = new UserListConsumerHandler(this, this.user, this.list);
                break;
            }
            case USER: {
                if (this.user == null || this.user.trim().isEmpty()) {
                    throw new IllegalArgumentException("Fetch type set to USER TIMELINE but no user was set.");
                }
                handler = new UserConsumerHandler(this, this.user);
                break;
            }
        }
        if (handler != null) {
            return TwitterHelper.createConsumer(processor, this, handler);
        }
        throw new IllegalArgumentException("Cannot create any consumer with uri " + this.getEndpointUri() + ". A consumer type was not provided (or an incorrect pairing was used).");
    }

    public TimelineType getTimelineType() {
        return this.timelineType;
    }
}

