/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.TwitterStream;
import twitter4j.TwitterStreamFactory;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterConfiguration {
    private String consumerKey;
    private String consumerSecret;
    private String accessToken;
    private String accessTokenSecret;
    private String type;
    private int delay = 60;
    private String user;
    private String keywords;
    private String locations;
    private String userIds;
    private boolean filterOld = true;
    private String date;
    private long sinceId = 1L;
    private String lang;
    private Integer count;
    private Date parsedDate;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private Twitter twitter;
    private TwitterStream twitterStream;
    private Integer numberOfPages = new Integer(1);

    public void checkComplete() {
        if (this.twitter == null && this.twitterStream == null && (this.consumerKey.isEmpty() || this.consumerSecret.isEmpty() || this.accessToken.isEmpty() || this.accessTokenSecret.isEmpty())) {
            throw new IllegalArgumentException("twitter or twitterStream or all of consumerKey, consumerSecret, accessToken, and accessTokenSecret must be set!");
        }
    }

    public Configuration getConfiguration() {
        ConfigurationBuilder confBuilder = new ConfigurationBuilder();
        confBuilder.setOAuthConsumerKey(this.consumerKey);
        confBuilder.setOAuthConsumerSecret(this.consumerSecret);
        confBuilder.setOAuthAccessToken(this.accessToken);
        confBuilder.setOAuthAccessTokenSecret(this.accessTokenSecret);
        return confBuilder.build();
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLocations() {
        return this.locations;
    }

    public void setLocations(String locations) {
        this.locations = locations;
    }

    public String getUserIds() {
        return this.userIds;
    }

    public void setUserIds(String userIds) {
        this.userIds = userIds;
    }

    public boolean isFilterOld() {
        return this.filterOld;
    }

    public void setFilterOld(boolean filterOld) {
        this.filterOld = filterOld;
    }

    public Twitter getTwitter() {
        if (this.twitter == null) {
            this.twitter = new TwitterFactory(this.getConfiguration()).getInstance();
        }
        return this.twitter;
    }

    public void setTwitter(Twitter twitter) {
        this.twitter = twitter;
    }

    public TwitterStream getTwitterStream() {
        return this.twitterStream;
    }

    public void setTwitterStream(TwitterStream twitterStream) {
        this.twitterStream = twitterStream;
    }

    public String getDate() {
        return this.date;
    }

    public Date parseDate() {
        return this.parsedDate;
    }

    public void setDate(String date) {
        this.date = date;
        try {
            this.parsedDate = this.sdf.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("date must be in yyyy-mm-dd format!");
        }
    }

    public TwitterStream createTwitterStream() {
        if (this.twitterStream == null) {
            this.twitterStream = new TwitterStreamFactory(this.getConfiguration()).getInstance();
        }
        return this.twitterStream;
    }

    public long getSinceId() {
        return this.sinceId;
    }

    public void setSinceId(long sinceId) {
        this.sinceId = sinceId;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Integer getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setNumberOfPages(Integer numberOfPages) {
        this.numberOfPages = numberOfPages;
    }
}

