/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.producer;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.impl.DefaultProducer;
import twitter4j.StatusUpdate;

public class UserProducer
extends DefaultProducer
implements Processor {
    private TwitterEndpoint te;

    public UserProducer(TwitterEndpoint te) {
        super((Endpoint)te);
        this.te = te;
    }

    public void process(Exchange exchange) throws Exception {
        Object in = exchange.getIn().getBody();
        if (in instanceof StatusUpdate) {
            this.updateStatus((StatusUpdate)in);
        } else {
            String s = (String)exchange.getIn().getMandatoryBody(String.class);
            this.updateStatus(s);
        }
    }

    private void updateStatus(StatusUpdate status) throws Exception {
        this.te.getTwitter().updateStatus(status);
        this.log.debug("Updated status: {}", (Object)status);
    }

    private void updateStatus(String status) throws Exception {
        if (status.length() > 160) {
            this.log.warn("Message is longer than 160 characters. Message will be truncated!");
            status = status.substring(0, 160);
        }
        this.te.getTwitter().updateStatus(status);
        this.log.debug("Updated status: {}", (Object)status);
    }
}

