/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.producer;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class DirectMessageProducer
extends DefaultProducer
implements Processor {
    private TwitterEndpoint te;

    public DirectMessageProducer(TwitterEndpoint te) {
        super((Endpoint)te);
        this.te = te;
    }

    public void process(Exchange exchange) throws Exception {
        String toUsername = this.te.getProperties().getUser();
        String text = (String)exchange.getIn().getBody(String.class);
        if (toUsername.isEmpty()) {
            throw new CamelExchangeException("Username not configured on TwitterEndpoint", exchange);
        }
        this.log.debug("Sending to: {} message: {}", (Object)toUsername, (Object)text);
        this.te.getTwitter().sendDirectMessage(toUsername, text);
    }
}

