/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.consumer.streaming;

import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.streaming.StreamingConsumer;
import twitter4j.FilterQuery;

public class FilterConsumer
extends StreamingConsumer {
    public FilterConsumer(TwitterEndpoint te) {
        super(te);
        this.twitterStream.filter(this.createFilter(te));
    }

    private FilterQuery createFilter(TwitterEndpoint te) {
        String userIds;
        String keywords;
        FilterQuery filterQuery = new FilterQuery();
        String allLocationsString = te.getProperties().getLocations();
        if (allLocationsString != null) {
            String[] locationStrings = allLocationsString.split(";");
            double[][] locations = new double[locationStrings.length][2];
            for (int i = 0; i < locationStrings.length; ++i) {
                String[] coords = locationStrings[i].split(",");
                locations[i][0] = Double.valueOf(coords[0]);
                locations[i][1] = Double.valueOf(coords[1]);
            }
            filterQuery.locations(locations);
        }
        if ((keywords = te.getProperties().getKeywords()) != null && keywords.length() > 0) {
            filterQuery.track(keywords.split(","));
        }
        if ((userIds = te.getProperties().getUserIds()) != null) {
            String[] stringUserIds = userIds.split(",");
            long[] longUserIds = new long[stringUserIds.length];
            for (int i = 0; i < stringUserIds.length; ++i) {
                longUserIds[i] = Long.valueOf(stringUserIds[i]);
            }
            filterQuery.follow(longUserIds);
        }
        if (allLocationsString == null && keywords == null && userIds == null) {
            throw new IllegalArgumentException("At least one filter parameter is required");
        }
        filterQuery.setIncludeEntities(true);
        return filterQuery;
    }
}

