/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.consumer.search;

import java.util.Collections;
import java.util.List;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.Twitter4JConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.Tweet;
import twitter4j.TwitterException;

public class SearchConsumer
extends Twitter4JConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(SearchConsumer.class);
    TwitterEndpoint te;

    public SearchConsumer(TwitterEndpoint te) {
        this.te = te;
    }

    public List<Tweet> pollConsume() throws TwitterException {
        String keywords = this.te.getProperties().getKeywords();
        Query query = new Query(keywords);
        if (this.te.getProperties().isFilterOld()) {
            query.setSinceId(this.lastId);
        }
        LOG.debug("Searching twitter with keywords: {}", (Object)keywords);
        return this.search(query);
    }

    public List<Tweet> directConsume() throws TwitterException {
        String keywords = this.te.getProperties().getKeywords();
        if (keywords == null || keywords.trim().length() == 0) {
            return Collections.emptyList();
        }
        LOG.debug("Searching twitter with keywords: {}", (Object)keywords);
        return this.search(new Query(keywords));
    }

    private List<Tweet> search(Query query) throws TwitterException {
        QueryResult qr = this.te.getTwitter().search(query);
        List tweets = qr.getTweets();
        if (this.te.getProperties().isFilterOld()) {
            for (Tweet t : tweets) {
                this.checkLastId(t.getId());
            }
        }
        return tweets;
    }
}

