/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.consumer;

import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.Twitter4JConsumer;
import org.apache.camel.component.twitter.consumer.TwitterConsumer;
import org.apache.camel.impl.ScheduledPollConsumer;

public class TwitterConsumerPolling
extends ScheduledPollConsumer
implements TwitterConsumer {
    private Twitter4JConsumer twitter4jConsumer;

    public TwitterConsumerPolling(TwitterEndpoint endpoint, Processor processor, Twitter4JConsumer twitter4jConsumer) {
        super((Endpoint)endpoint, processor);
        this.twitter4jConsumer = twitter4jConsumer;
        int delay = endpoint.getProperties().getDelay();
        this.setInitialDelay(1L);
        this.setDelay(delay);
        this.setTimeUnit(TimeUnit.SECONDS);
    }

    protected int poll() throws Exception {
        Iterator<? extends Serializable> i = this.twitter4jConsumer.pollConsume().iterator();
        int total = 0;
        while (i.hasNext()) {
            Exchange e = this.getEndpoint().createExchange();
            e.getIn().setBody((Object)i.next());
            this.getProcessor().process(e);
            ++total;
        }
        return total;
    }
}

