/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.consumer;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.direct.DirectConsumer;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.TweeterStatusListener;
import org.apache.camel.component.twitter.consumer.Twitter4JConsumer;
import org.apache.camel.component.twitter.consumer.TwitterConsumer;
import org.apache.camel.component.twitter.consumer.streaming.StreamingConsumer;
import twitter4j.Status;

public class TwitterConsumerEvent
extends DirectConsumer
implements TwitterConsumer,
TweeterStatusListener {
    private Twitter4JConsumer twitter4jConsumer;

    public TwitterConsumerEvent(TwitterEndpoint endpoint, Processor processor, Twitter4JConsumer twitter4jConsumer) {
        super((Endpoint)endpoint, processor);
        this.twitter4jConsumer = twitter4jConsumer;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.twitter4jConsumer instanceof StreamingConsumer) {
            ((StreamingConsumer)this.twitter4jConsumer).registerTweetListener(this);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.twitter4jConsumer instanceof StreamingConsumer) {
            ((StreamingConsumer)this.twitter4jConsumer).unregisterTweetListener(this);
        }
    }

    @Override
    public void onStatus(Status status) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody((Object)status);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

