/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter;

import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.TwitterStream;
import twitter4j.TwitterStreamFactory;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterConfiguration {
    private String consumerKey;
    private String consumerSecret;
    private String accessToken;
    private String accessTokenSecret;
    private String user;
    private String keywords;
    private int delay = 60;
    private String type;
    private String locations;
    private String userIds;
    private boolean filterOld = true;
    private Twitter twitter;
    private TwitterStream twitterStream;

    public void checkComplete() {
        if (this.twitter == null && this.twitterStream == null && (this.consumerKey.isEmpty() || this.consumerSecret.isEmpty() || this.accessToken.isEmpty() || this.accessTokenSecret.isEmpty())) {
            throw new IllegalArgumentException("twitter or twitterStream or all of consumerKey, consumerSecret, accessToken, and accessTokenSecret must be set!");
        }
    }

    public Configuration getConfiguration() {
        ConfigurationBuilder confBuilder = new ConfigurationBuilder();
        confBuilder.setOAuthConsumerKey(this.consumerKey);
        confBuilder.setOAuthConsumerSecret(this.consumerSecret);
        confBuilder.setOAuthAccessToken(this.accessToken);
        confBuilder.setOAuthAccessTokenSecret(this.accessTokenSecret);
        return confBuilder.build();
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLocations() {
        return this.locations;
    }

    public void setLocations(String locations) {
        this.locations = locations;
    }

    public String getUserIds() {
        return this.userIds;
    }

    public void setUserIds(String userIds) {
        this.userIds = userIds;
    }

    public boolean isFilterOld() {
        return this.filterOld;
    }

    public void setFilterOld(boolean filterOld) {
        this.filterOld = filterOld;
    }

    public Twitter getTwitter() {
        return this.twitter;
    }

    public void setTwitter(Twitter twitter) {
        this.twitter = twitter;
    }

    public TwitterStream getTwitterStream() {
        return this.twitterStream;
    }

    public void setTwitterStream(TwitterStream twitterStream) {
        this.twitterStream = twitterStream;
    }

    public Twitter getTwitterInstance() {
        this.checkComplete();
        return this.getTwitter() != null ? this.getTwitter() : new TwitterFactory(this.getConfiguration()).getInstance();
    }

    public TwitterStream getTwitterStreamInstance() {
        this.checkComplete();
        return this.getTwitterStream() != null ? this.getTwitterStream() : new TwitterStreamFactory(this.getConfiguration()).getInstance();
    }
}

