/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twilio;

import com.twilio.http.TwilioRestClient;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.twilio.TwilioComponent;
import org.apache.camel.component.twilio.TwilioConfiguration;
import org.apache.camel.component.twilio.TwilioConsumer;
import org.apache.camel.component.twilio.TwilioProducer;
import org.apache.camel.component.twilio.internal.TwilioApiCollection;
import org.apache.camel.component.twilio.internal.TwilioApiName;
import org.apache.camel.component.twilio.internal.TwilioPropertiesHelper;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodPropertiesHelper;
import org.apache.camel.support.component.ApiName;

@UriEndpoint(firstVersion="2.20.0", scheme="twilio", title="Twilio", syntax="twilio:apiName/methodName", apiSyntax="apiName/methodName", category={Category.API, Category.MESSAGING, Category.CLOUD})
public class TwilioEndpoint
extends AbstractApiEndpoint<TwilioApiName, TwilioConfiguration> {
    protected static final Map<String, String> EXECUTOR_METHOD_MAP;
    protected final TwilioComponent component;
    @UriParam
    private TwilioConfiguration configuration;

    public TwilioEndpoint(String uri, TwilioComponent component, TwilioApiName apiName, String methodName, TwilioConfiguration endpointConfiguration) {
        super(uri, (Component)component, (ApiName)apiName, methodName, TwilioApiCollection.getCollection().getHelper(apiName), (Object)endpointConfiguration);
        this.component = component;
        this.configuration = endpointConfiguration;
    }

    public Producer createProducer() throws Exception {
        return new TwilioProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.inBody != null) {
            throw new IllegalArgumentException("Option inBody is not supported for consumer endpoint");
        }
        TwilioConsumer consumer = new TwilioConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected void afterConfigureProperties() {
    }

    public Object getApiProxy(ApiMethod method, Map<String, Object> args) {
        return null;
    }

    public Object execute(Object executor, ApiMethod method, Map<String, Object> properties) {
        if (!EXECUTOR_METHOD_MAP.containsKey(method.getName())) {
            throw new IllegalArgumentException("Invalid method name " + method.getName());
        }
        String methodName = EXECUTOR_METHOD_MAP.get(method.getName());
        try {
            BeanIntrospection beanIntrospection = PluginHelper.getBeanIntrospection((CamelContext)this.getCamelContext());
            for (Map.Entry<String, Object> p : properties.entrySet()) {
                beanIntrospection.setProperty(this.getCamelContext(), executor, p.getKey(), p.getValue());
            }
            return this.doExecute(executor, methodName, properties);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    protected Object doExecute(Object executor, String methodName, Map<String, Object> properties) throws Exception {
        Method method = executor.getClass().getDeclaredMethod(methodName, TwilioRestClient.class);
        return method.invoke(executor, properties.getOrDefault("client", this.getRestClient()));
    }

    protected ApiMethodPropertiesHelper<TwilioConfiguration> getPropertiesHelper() {
        return TwilioPropertiesHelper.getHelper(this.getCamelContext());
    }

    protected String getThreadProfileName() {
        return "CamelTwilio";
    }

    public TwilioRestClient getRestClient() {
        return this.component.getRestClient();
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("creator", "create");
        map.put("deleter", "delete");
        map.put("fetcher", "fetch");
        map.put("reader", "read");
        map.put("updater", "update");
        EXECUTOR_METHOD_MAP = Collections.unmodifiableMap(map);
    }
}

