/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twilio;

import com.twilio.type.Endpoint;
import com.twilio.type.Twiml;
import java.net.URI;
import org.apache.camel.component.twilio.TwilioConfiguration;
import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@ApiParams(apiName="call", description="", apiMethods={@ApiMethod(methodName="creator", description="Create a CallCreator to execute create", signatures={"com.twilio.rest.api.v2010.account.CallCreator creator(com.twilio.type.Endpoint to, com.twilio.type.Endpoint from, String applicationSid)", "com.twilio.rest.api.v2010.account.CallCreator creator(com.twilio.type.Endpoint to, com.twilio.type.Endpoint from, com.twilio.type.Twiml twiml)", "com.twilio.rest.api.v2010.account.CallCreator creator(com.twilio.type.Endpoint to, com.twilio.type.Endpoint from, java.net.URI url)", "com.twilio.rest.api.v2010.account.CallCreator creator(String pathAccountSid, com.twilio.type.Endpoint to, com.twilio.type.Endpoint from, String applicationSid)", "com.twilio.rest.api.v2010.account.CallCreator creator(String pathAccountSid, com.twilio.type.Endpoint to, com.twilio.type.Endpoint from, com.twilio.type.Twiml twiml)", "com.twilio.rest.api.v2010.account.CallCreator creator(String pathAccountSid, com.twilio.type.Endpoint to, com.twilio.type.Endpoint from, java.net.URI url)"}), @ApiMethod(methodName="deleter", description="Create a CallDeleter to execute delete", signatures={"com.twilio.rest.api.v2010.account.CallDeleter deleter(String pathSid)", "com.twilio.rest.api.v2010.account.CallDeleter deleter(String pathAccountSid, String pathSid)"}), @ApiMethod(methodName="fetcher", description="Create a CallFetcher to execute fetch", signatures={"com.twilio.rest.api.v2010.account.CallFetcher fetcher(String pathSid)", "com.twilio.rest.api.v2010.account.CallFetcher fetcher(String pathAccountSid, String pathSid)"}), @ApiMethod(methodName="reader", description="Create a CallReader to execute read", signatures={"com.twilio.rest.api.v2010.account.CallReader reader()", "com.twilio.rest.api.v2010.account.CallReader reader(String pathAccountSid)"}), @ApiMethod(methodName="updater", description="Create a CallUpdater to execute update", signatures={"com.twilio.rest.api.v2010.account.CallUpdater updater(String pathSid)", "com.twilio.rest.api.v2010.account.CallUpdater updater(String pathAccountSid, String pathSid)"})}, aliases={"^creator$=create", "^deleter$=delete", "^fetcher$=fetch", "^reader$=read", "^updater$=update"})
@UriParams
@Configurer(extended=true)
public final class CallEndpointConfiguration
extends TwilioConfiguration {
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="creator", description="The SID of the Application resource that will handle the call")})
    private String applicationSid;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="creator", description="Twilio number from which to originate the call")})
    private Endpoint from;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="creator", description="The SID of the Account that will create the resource"), @ApiMethod(methodName="deleter", description="The SID of the Account that created the resource(s) to delete"), @ApiMethod(methodName="fetcher", description="The SID of the Account that created the resource(s) to fetch"), @ApiMethod(methodName="reader", description="The SID of the Account that created the resource(s) to read"), @ApiMethod(methodName="updater", description="The SID of the Account that created the resource(s) to update")})
    private String pathAccountSid;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="deleter", description="The unique string that identifies this resource"), @ApiMethod(methodName="fetcher", description="The SID of the Call resource to fetch"), @ApiMethod(methodName="updater", description="The unique string that identifies this resource")})
    private String pathSid;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="creator", description="Phone number, SIP address, or client identifier to call")})
    private Endpoint to;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="creator", description="TwiML instructions for the call")})
    private Twiml twiml;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="creator", description="The absolute URL that returns TwiML for this call")})
    private URI url;

    public String getApplicationSid() {
        return this.applicationSid;
    }

    public void setApplicationSid(String applicationSid) {
        this.applicationSid = applicationSid;
    }

    public Endpoint getFrom() {
        return this.from;
    }

    public void setFrom(Endpoint from) {
        this.from = from;
    }

    public String getPathAccountSid() {
        return this.pathAccountSid;
    }

    public void setPathAccountSid(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public String getPathSid() {
        return this.pathSid;
    }

    public void setPathSid(String pathSid) {
        this.pathSid = pathSid;
    }

    public Endpoint getTo() {
        return this.to;
    }

    public void setTo(Endpoint to) {
        this.to = to;
    }

    public Twiml getTwiml() {
        return this.twiml;
    }

    public void setTwiml(Twiml twiml) {
        this.twiml = twiml;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }
}

