/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing.decorators;

import java.time.Duration;
import java.time.OffsetDateTime;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.decorators.AbstractMessagingSpanDecorator;

public class AzureStorageQueueSpanDecorator
extends AbstractMessagingSpanDecorator {
    static final String STORAGE_QUEUE_INSERTION_TIME = "insertionTime";
    static final String STORAGE_QUEUE_EXPIRATION_TIME = "expirationTime";
    static final String STORAGE_QUEUE_TIME_NEXT_VISIBLE = "timeNextVisible";
    static final String STORAGE_QUEUE_DEQUEUE_COUNT = "dequeueCount";
    static final String STORAGE_QUEUE_NAME = "name";
    static final String STORAGE_QUEUE_VISIBILITY_TIMEOUT = "visibilityTimeout";
    static final String STORAGE_QUEUE_TIME_TO_LIVE = "ttl";
    static final String MESSAGE_ID = "CamelAzureStorageQueueMessageId";
    static final String INSERTION_TIME = "CamelAzureStorageQueueInsertionTime";
    static final String EXPIRATION_TIME = "CamelAzureStorageQueueExpirationTime";
    static final String TIME_NEXT_VISIBLE = "CamelAzureStorageQueueTimeNextVisible";
    static final String DEQUEUE_COUNT = "CamelAzureStorageQueueDequeueCount";
    static final String NAME = "CamelAzureStorageQueueName";
    static final String VISIBILITY_TIMEOUT = "CamelAzureStorageQueueVisibilityTimeout";
    static final String TIME_TO_LIVE = "CamelAzureStorageQueueTimeToLive";

    @Override
    public String getComponent() {
        return "azure-storage-queue";
    }

    @Override
    public String getComponentClassName() {
        return "org.apache.camel.component.azure.storage.queue.QueueComponent";
    }

    @Override
    public void pre(SpanAdapter span, Exchange exchange, Endpoint endpoint) {
        Duration timeToLive;
        Duration visibilityTimeout;
        String name;
        Long dequeueCount;
        OffsetDateTime timeNextVisible;
        OffsetDateTime expirationTime;
        super.pre(span, exchange, endpoint);
        OffsetDateTime insertionTime = (OffsetDateTime)exchange.getIn().getHeader(INSERTION_TIME, OffsetDateTime.class);
        if (insertionTime != null) {
            span.setTag(STORAGE_QUEUE_INSERTION_TIME, insertionTime.toString());
        }
        if ((expirationTime = (OffsetDateTime)exchange.getIn().getHeader(EXPIRATION_TIME, OffsetDateTime.class)) != null) {
            span.setTag(STORAGE_QUEUE_EXPIRATION_TIME, expirationTime.toString());
        }
        if ((timeNextVisible = (OffsetDateTime)exchange.getIn().getHeader(TIME_NEXT_VISIBLE, OffsetDateTime.class)) != null) {
            span.setTag(STORAGE_QUEUE_TIME_NEXT_VISIBLE, timeNextVisible.toString());
        }
        if ((dequeueCount = (Long)exchange.getIn().getHeader(DEQUEUE_COUNT, Long.class)) != null) {
            span.setTag(STORAGE_QUEUE_DEQUEUE_COUNT, (Number)dequeueCount);
        }
        if ((name = (String)exchange.getIn().getHeader(NAME, String.class)) != null) {
            span.setTag(STORAGE_QUEUE_NAME, name);
        }
        if ((visibilityTimeout = (Duration)exchange.getIn().getHeader(VISIBILITY_TIMEOUT, Duration.class)) != null) {
            span.setTag(STORAGE_QUEUE_VISIBILITY_TIMEOUT, visibilityTimeout.toString());
        }
        if ((timeToLive = (Duration)exchange.getIn().getHeader(TIME_TO_LIVE, Duration.class)) != null) {
            span.setTag(STORAGE_QUEUE_TIME_TO_LIVE, timeToLive.toString());
        }
    }

    @Override
    protected String getMessageId(Exchange exchange) {
        return (String)exchange.getIn().getHeader(MESSAGE_ID, String.class);
    }
}

