/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing.propagation;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.camel.tracing.ExtractAdapter;

public final class CamelMessagingHeadersExtractAdapter
implements ExtractAdapter {
    private final Map<String, String> map = new HashMap<String, String>();
    private final boolean jmsEncoding;

    public CamelMessagingHeadersExtractAdapter(Map<String, Object> map, boolean jmsEncoding) {
        this.jmsEncoding = jmsEncoding;
        map.entrySet().stream().filter(e -> e.getValue() instanceof String || e.getValue() instanceof byte[]).forEach(e -> {
            if (e.getValue() instanceof byte[]) {
                this.map.put(this.decodeDash((String)e.getKey()), new String((byte[])e.getValue(), StandardCharsets.UTF_8));
            } else {
                this.map.put(this.decodeDash((String)e.getKey()), (String)e.getValue());
            }
        });
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.map.entrySet().iterator();
    }

    @Override
    public Object get(String key) {
        return this.map.get(key);
    }

    @Override
    public Set<String> keys() {
        return this.map.keySet();
    }

    private String decodeDash(String key) {
        if (this.jmsEncoding) {
            return key.replace("_$dash$_", "-");
        }
        return key;
    }
}

