/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.torchserve.client;

import java.util.Optional;
import org.apache.camel.component.torchserve.client.Inference;
import org.apache.camel.component.torchserve.client.Management;
import org.apache.camel.component.torchserve.client.Metrics;
import org.apache.camel.component.torchserve.client.impl.DefaultInference;
import org.apache.camel.component.torchserve.client.impl.DefaultManagement;
import org.apache.camel.component.torchserve.client.impl.DefaultMetrics;

public class TorchServeClient {
    private final Inference inference;
    private final Management management;
    private final Metrics metrics;

    private TorchServeClient(Inference inference, Management management, Metrics metrics) {
        this.inference = inference;
        this.management = management;
        this.metrics = metrics;
    }

    public static TorchServeClient newInstance() {
        return TorchServeClient.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Inference inference() {
        return this.inference;
    }

    public Management management() {
        return this.management;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public static class Builder {
        private Optional<String> inferenceKey = Optional.empty();
        private Optional<String> inferenceAddress = Optional.empty();
        private Optional<Integer> inferencePort = Optional.empty();
        private Optional<String> managementKey = Optional.empty();
        private Optional<String> managementAddress = Optional.empty();
        private Optional<Integer> managementPort = Optional.empty();
        private Optional<String> metricsAddress = Optional.empty();
        private Optional<Integer> metricsPort = Optional.empty();

        public Builder inferenceKey(String key) {
            this.inferenceKey = Optional.of(key);
            return this;
        }

        public Builder inferenceAddress(String address) {
            this.inferenceAddress = Optional.of(address);
            return this;
        }

        public Builder inferencePort(int port) {
            this.inferencePort = Optional.of(port);
            return this;
        }

        public Builder managementKey(String key) {
            this.managementKey = Optional.of(key);
            return this;
        }

        public Builder managementAddress(String address) {
            this.managementAddress = Optional.of(address);
            return this;
        }

        public Builder managementPort(int port) {
            this.managementPort = Optional.of(port);
            return this;
        }

        public Builder metricsAddress(String address) {
            this.metricsAddress = Optional.of(address);
            return this;
        }

        public Builder metricsPort(Integer port) {
            this.metricsPort = Optional.of(port);
            return this;
        }

        public TorchServeClient build() {
            DefaultInference inference = this.inferenceAddress.map(DefaultInference::new).or(() -> this.inferencePort.map(DefaultInference::new)).orElse(new DefaultInference());
            this.inferenceKey.ifPresent(inference::setAuthToken);
            DefaultManagement management = this.managementAddress.map(DefaultManagement::new).or(() -> this.managementPort.map(DefaultManagement::new)).orElse(new DefaultManagement());
            this.managementKey.ifPresent(management::setAuthToken);
            DefaultMetrics metrics = this.metricsAddress.map(DefaultMetrics::new).or(() -> this.metricsPort.map(DefaultMetrics::new)).orElse(new DefaultMetrics());
            return new TorchServeClient(inference, management, metrics);
        }
    }
}

