/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.util;

import org.apache.camel.tooling.util.Strings;

public final class JavadocHelper {
    private static final String VALID_CHARS = ".,-='/\\!&%():;#${}";

    private JavadocHelper() {
    }

    public static String sanitizeDescription(String javadoc, boolean summary) {
        if (Strings.isNullOrEmpty(javadoc)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String[] lines = javadoc.split("\n");
        boolean first = true;
        for (String line : lines) {
            boolean haveText;
            if ((line = line.trim()).startsWith("**")) continue;
            if (line.startsWith("*")) {
                line = line.substring(1);
                line = line.trim();
            }
            if (line.startsWith("@param") || line.startsWith("@return") || line.startsWith("@deprecated")) break;
            if (line.startsWith("@")) continue;
            if (!first) {
                sb.append(' ');
            }
            String s = line.trim();
            sb.append(s);
            boolean empty = Strings.isNullOrEmpty(s);
            boolean endWithDot = s.endsWith(".");
            boolean bl = haveText = sb.length() > 0;
            if (haveText && summary && (empty || endWithDot)) break;
            first = false;
        }
        String s = sb.toString();
        s = s.replaceAll("<.*?>", "");
        s = s.replaceAll("\\{@link\\s\\w+\\s(\\w+)}", "$1");
        s = s.replaceAll("\\{@link\\s([\\w]+)}", "$1");
        s = s.replaceAll("@\\{link\\s\\w+\\s(\\w+)}", "$1");
        s = s.replaceAll("@\\{link\\s([\\w]+)}", "$1");
        s = s.replaceAll("\\{@\\w+\\s#?([\\w.#(\\d,)]+)}", "$1");
        StringBuilder cb = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (Character.isJavaIdentifierPart(c) || VALID_CHARS.indexOf(c) != -1) {
                cb.append(c);
                continue;
            }
            if (!Character.isWhitespace(c)) continue;
            cb.append(' ');
        }
        s = cb.toString();
        s = s.replaceAll("\\s+", " ");
        s = s.replaceAll("\\\\(http:|https:)", "$1");
        return s.trim();
    }

    public static String xmlEncode(String text) {
        if (text == null) {
            return "";
        }
        text = text.replace("&", "&amp;");
        text = text.replace("\"", "&quot;");
        text = text.replace("<", "&lt;");
        text = text.replace(">", "&gt;");
        return text;
    }
}

