/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tika;

import java.nio.charset.Charset;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.tika.TikaOperation;
import org.apache.camel.component.tika.TikaParseOutputFormat;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.tika.config.TikaConfig;

@UriParams
public class TikaConfiguration {
    @UriPath(description="Operation type")
    @Metadata(required=true)
    private TikaOperation operation;
    @UriParam(defaultValue="xml")
    private TikaParseOutputFormat tikaParseOutputFormat = TikaParseOutputFormat.xml;
    @UriParam(description="Tika Parse Output Encoding")
    private String tikaParseOutputEncoding = Charset.defaultCharset().name();
    @UriParam(label="advanced", description="Tika Config")
    private TikaConfig tikaConfig = TikaConfig.getDefaultConfig();
    @UriParam(label="advanced", description="Tika Config Url")
    private String tikaConfigUri;

    public TikaOperation getOperation() {
        return this.operation;
    }

    public void setOperation(TikaOperation operation) {
        this.operation = operation;
    }

    public void setOperation(String operation) {
        this.operation = TikaOperation.valueOf(operation);
    }

    public TikaParseOutputFormat getTikaParseOutputFormat() {
        return this.tikaParseOutputFormat;
    }

    public void setTikaParseOutputFormat(TikaParseOutputFormat tikaParseOutputFormat) {
        this.tikaParseOutputFormat = tikaParseOutputFormat;
    }

    public String getTikaParseOutputEncoding() {
        return this.tikaParseOutputEncoding;
    }

    public void setTikaParseOutputEncoding(String tikaParseOutputEncoding) {
        this.tikaParseOutputEncoding = tikaParseOutputEncoding;
    }

    public TikaConfig getTikaConfig() {
        return this.tikaConfig;
    }

    public void setTikaConfig(TikaConfig tikaConfig) {
        this.tikaConfig = tikaConfig;
    }

    public String getTikaConfigUri() {
        return this.tikaConfigUri;
    }

    public void setTikaConfigUri(String tikaConfigUri) {
        this.tikaConfigUri = tikaConfigUri;
        try {
            this.tikaConfig = new TikaConfig(tikaConfigUri);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

