/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.spring.junit5;

import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.test.spring.junit5.CamelAnnotationsHandler;
import org.apache.camel.test.spring.junit5.SpringTestExecutionListenerSorter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class CamelSpringBootExecutionListener
extends AbstractTestExecutionListener {
    protected static final ThreadLocal<ConfigurableApplicationContext> threadApplicationContext = new ThreadLocal();
    private static final Logger LOG = LoggerFactory.getLogger(CamelSpringBootExecutionListener.class);
    private static final String PROPERTY_SKIP_STARTING_CAMEL_CONTEXT = "skipStartingCamelContext";

    public int getOrder() {
        return SpringTestExecutionListenerSorter.getPrecedence(((Object)((Object)this)).getClass());
    }

    public void beforeTestClass(TestContext testContext) throws Exception {
        this.preventContextStart();
    }

    public void prepareTestInstance(TestContext testContext) throws Exception {
        LOG.info("CamelSpringBootExecutionListener preparing: {}", (Object)testContext.getTestClass());
        Class testClass = testContext.getTestClass();
        CamelAnnotationsHandler.handleDisableJmx(testClass);
        CamelAnnotationsHandler.handleExcludeRoutes(testClass);
        this.preventContextStart();
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)testContext.getApplicationContext();
        CamelAnnotationsHandler.handleUseOverridePropertiesWithPropertiesComponent(context, testClass);
        CamelAnnotationsHandler.handleProvidesBreakpoint(context, testClass);
        CamelAnnotationsHandler.handleShutdownTimeout(context, testClass);
        CamelAnnotationsHandler.handleMockEndpoints(context, testClass);
        CamelAnnotationsHandler.handleMockEndpointsAndSkip(context, testClass);
        System.clearProperty(PROPERTY_SKIP_STARTING_CAMEL_CONTEXT);
        SpringCamelContext.setNoStart((boolean)false);
    }

    private void preventContextStart() {
        SpringCamelContext.setNoStart((boolean)true);
        System.setProperty(PROPERTY_SKIP_STARTING_CAMEL_CONTEXT, "true");
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        LOG.info("CamelSpringBootExecutionListener before: {}.{}", (Object)testContext.getTestClass(), (Object)testContext.getTestMethod().getName());
        Class testClass = testContext.getTestClass();
        String testName = testContext.getTestMethod().getName();
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)testContext.getApplicationContext();
        threadApplicationContext.set(context);
        System.clearProperty(PROPERTY_SKIP_STARTING_CAMEL_CONTEXT);
        CamelAnnotationsHandler.handleRouteCoverage(context, testClass, s -> testName);
        LOG.info("Initialized CamelSpringBootExecutionListener now ready to start CamelContext");
        CamelAnnotationsHandler.handleCamelContextStartup(context, testClass);
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        LOG.info("CamelSpringBootExecutionListener after: {}.{}", (Object)testContext.getTestClass(), (Object)testContext.getTestMethod().getName());
        Class testClass = testContext.getTestClass();
        String testName = testContext.getTestMethod().getName();
        ConfigurableApplicationContext context = threadApplicationContext.get();
        if (context != null && context.isRunning()) {
            CamelAnnotationsHandler.handleRouteCoverageDump(context, testClass, s -> testName);
        }
    }
}

