/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.spring.junit5;

import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.DumpRoutesStrategy;
import org.apache.camel.support.EventNotifierSupport;

public class RouteDumpEventNotifier
extends EventNotifierSupport {
    private final String testClassName;
    private final Function<RouteDumpEventNotifier, String> testMethodName;
    private final String format;

    public RouteDumpEventNotifier(String testClassName, Function<RouteDumpEventNotifier, String> testMethodName, String format) {
        this.testClassName = testClassName;
        this.testMethodName = testMethodName;
        this.format = format;
        this.setIgnoreCamelContextEvents(false);
        this.setIgnoreExchangeEvents(true);
    }

    public boolean isEnabled(CamelEvent event) {
        return event instanceof CamelEvent.CamelContextStoppingEvent;
    }

    public void notify(CamelEvent event) throws Exception {
        CamelContext context = ((CamelEvent.CamelContextStoppingEvent)event).getContext();
        String testName = this.testMethodName.apply(this);
        String dir = "target/camel-route-dump";
        String ext = this.format.toLowerCase();
        String name = String.format("%s-%s.%s", this.testClassName, testName, ext);
        DumpRoutesStrategy drs = (DumpRoutesStrategy)context.getCamelContextExtension().getContextPlugin(DumpRoutesStrategy.class);
        drs.setOutput(dir + "/" + name);
        drs.setInclude("*");
        drs.setLog(false);
        drs.setUriAsParameters(true);
        drs.dumpRoutes(this.format);
    }
}

