/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.spring.junit5;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.camel.spring.SpringCamelContext;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;

public final class CamelSpringTestHelper {
    private static ThreadLocal<String> originalJmxDisabledValue = new ThreadLocal();
    private static ThreadLocal<String> originalExcludeRoutesValue = new ThreadLocal();
    private static ThreadLocal<Class<?>> testClazz = new ThreadLocal();
    private static ThreadLocal<TestContext> testContext = new ThreadLocal();

    private CamelSpringTestHelper() {
    }

    public static String getOriginalJmxDisabled() {
        return originalJmxDisabledValue.get();
    }

    public static void setOriginalJmxDisabledValue(String originalValue) {
        originalJmxDisabledValue.set(originalValue);
    }

    public static String getOriginalExcludeRoutes() {
        return originalExcludeRoutesValue.get();
    }

    public static void setOriginalExcludeRoutesValue(String originalValue) {
        originalExcludeRoutesValue.set(originalValue);
    }

    public static Class<?> getTestClass() {
        return testClazz.get();
    }

    public static void setTestClass(Class<?> testClass) {
        testClazz.set(testClass);
    }

    public static Method getTestMethod() {
        return testContext.get().getTestMethod();
    }

    public static void setTestContext(TestContext context) {
        testContext.set(context);
    }

    public static Collection<Method> getAllMethods(Class<?> clazz) {
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            methods.addAll(Arrays.asList(clazz.getMethods()));
        }
        return methods;
    }

    public static void doToSpringCamelContexts(ApplicationContext context, DoToSpringCamelContextsStrategy strategy) throws Exception {
        Map contexts = context.getBeansOfType(SpringCamelContext.class);
        for (Map.Entry entry : contexts.entrySet()) {
            strategy.execute((String)entry.getKey(), (SpringCamelContext)entry.getValue());
        }
    }

    public static interface DoToSpringCamelContextsStrategy {
        public void execute(String var1, SpringCamelContext var2) throws Exception;
    }
}

