/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.karaf;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.apache.camel.test.karaf.AbstractFeatureTest;
import org.apache.camel.util.ObjectHelper;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.ProbeBuilder;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class CamelKarafTestSupport
extends CamelTestSupport {
    static final Long COMMAND_TIMEOUT = 30000L;
    static final Long SERVICE_TIMEOUT = 30000L;
    protected ExecutorService executor = Executors.newCachedThreadPool();
    @Inject
    protected BundleContext bundleContext;
    @Inject
    protected FeaturesService featuresService;

    @ProbeBuilder
    public TestProbeBuilder probeConfiguration(TestProbeBuilder probe) {
        probe.setHeader("DynamicImport-Package", "*,org.apache.felix.service.*;status=provisional");
        return probe;
    }

    public File getConfigFile(String path) {
        URL res = ((Object)((Object)this)).getClass().getResource(path);
        if (res == null) {
            throw new RuntimeException("Config resource " + path + " not found");
        }
        return new File(res.getFile());
    }

    public static Option[] configure(String ... extra) {
        return AbstractFeatureTest.configure(extra);
    }

    protected String executeCommand(String command, Principal ... principals) {
        return this.executeCommand(command, COMMAND_TIMEOUT, false, principals);
    }

    protected String executeCommand(final String command, Long timeout, final Boolean silent, final Principal ... principals) {
        String response;
        this.waitForCommandService(command);
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        final PrintStream printStream = new PrintStream(byteArrayOutputStream);
        final Callable<String> commandCallable = new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    if (!silent.booleanValue()) {
                        System.err.println(command);
                    }
                    CommandProcessor commandProcessor = CamelKarafTestSupport.this.getOsgiService(CommandProcessor.class);
                    CommandSession commandSession = commandProcessor.createSession(System.in, (OutputStream)printStream, (OutputStream)System.err);
                    commandSession.execute((CharSequence)command);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                printStream.flush();
                return byteArrayOutputStream.toString();
            }
        };
        FutureTask<String> commandFuture = principals.length == 0 ? new FutureTask<String>(commandCallable) : new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Subject subject = new Subject();
                subject.getPrincipals().addAll(Arrays.asList(principals));
                return Subject.doAs(subject, new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws Exception {
                        return (String)commandCallable.call();
                    }
                });
            }
        });
        try {
            this.executor.submit(commandFuture);
            response = commandFuture.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            response = "SHELL COMMAND TIMED OUT: ";
        }
        return response;
    }

    private void waitForCommandService(String command) {
        if (command == null || command.length() == 0) {
            return;
        }
        int spaceIdx = command.indexOf(32);
        if (spaceIdx > 0) {
            command = command.substring(0, spaceIdx);
        }
        int colonIndx = command.indexOf(58);
        try {
            if (colonIndx > 0) {
                String scope = command.substring(0, colonIndx);
                String function = command.substring(colonIndx + 1);
                this.waitForService("(&(osgi.command.scope=" + scope + ")(osgi.command.function=" + function + "))", SERVICE_TIMEOUT);
            } else {
                this.waitForService("(osgi.command.function=" + command + ")", SERVICE_TIMEOUT);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForService(String filter, long timeout) throws InvalidSyntaxException, InterruptedException {
        try (ServiceTracker st = new ServiceTracker(this.bundleContext, this.bundleContext.createFilter(filter), null);){
            st.open();
            st.waitForService(timeout);
        }
    }

    protected <T> T getOsgiService(Class<T> type, long timeout) {
        return this.getOsgiService(type, null, timeout);
    }

    protected <T> T getOsgiService(Class<T> type) {
        return this.getOsgiService(type, null, SERVICE_TIMEOUT);
    }

    protected <T> T getOsgiService(Class<T> type, String filter, long timeout) {
        ServiceTracker tracker = null;
        try {
            String flt = filter != null ? (filter.startsWith("(") ? "(&(objectClass=" + type.getName() + ")" + filter + ")" : "(&(objectClass=" + type.getName() + ")(" + filter + "))") : "(objectClass=" + type.getName() + ")";
            Filter osgiFilter = FrameworkUtil.createFilter((String)flt);
            tracker = new ServiceTracker(this.bundleContext, osgiFilter, null);
            tracker.open(true);
            T svc = type.cast(tracker.waitForService(timeout));
            if (svc == null) {
                Dictionary dic = this.bundleContext.getBundle().getHeaders();
                System.err.println("Test bundle headers: " + CamelKarafTestSupport.explode(dic));
                for (ServiceReference ref : CamelKarafTestSupport.asCollection(this.bundleContext.getAllServiceReferences(null, null))) {
                    System.err.println("ServiceReference: " + ref);
                }
                for (ServiceReference ref : CamelKarafTestSupport.asCollection(this.bundleContext.getAllServiceReferences(null, flt))) {
                    System.err.println("Filtered ServiceReference: " + ref);
                }
                throw new RuntimeException("Gave up waiting for service " + flt);
            }
            return type.cast(svc);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static String explode(Dictionary dictionary) {
        Enumeration keys = dictionary.keys();
        StringBuilder sb = new StringBuilder();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            sb.append(String.format("%s=%s", key, dictionary.get(key)));
            if (!keys.hasMoreElements()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private static Collection<ServiceReference> asCollection(ServiceReference[] references) {
        return references != null ? Arrays.asList(references) : Collections.emptyList();
    }

    public JMXConnector getJMXConnector() throws Exception {
        return this.getJMXConnector("karaf", "karaf");
    }

    public JMXConnector getJMXConnector(String userName, String passWord) throws Exception {
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:1099/karaf-root");
        Hashtable<String, String[]> env = new Hashtable<String, String[]>();
        String[] credentials = new String[]{userName, passWord};
        env.put("jmx.remote.credentials", credentials);
        JMXConnector connector = JMXConnectorFactory.connect(url, env);
        return connector;
    }

    public void assertFeatureInstalled(String featureName) {
        try {
            Feature[] features;
            for (Feature feature : features = this.featuresService.listInstalledFeatures()) {
                if (!featureName.equals(feature.getName())) continue;
                return;
            }
            CamelKarafTestSupport.fail((String)("Feature " + featureName + " should be installed but is not"));
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public void assertFeatureInstalled(String featureName, String featureVersion) {
        try {
            Feature[] features;
            for (Feature feature : features = this.featuresService.listInstalledFeatures()) {
                if (!featureName.equals(feature.getName()) || !featureVersion.equals(feature.getVersion())) continue;
                return;
            }
            CamelKarafTestSupport.fail((String)("Feature " + featureName + "/" + featureVersion + " should be installed but is not"));
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }

    protected void installAndAssertFeature(String feature) throws Exception {
        this.featuresService.installFeature(feature);
        this.assertFeatureInstalled(feature);
    }

    protected void installAndAssertFeature(String feature, String version) throws Exception {
        this.featuresService.installFeature(feature, version);
        this.assertFeatureInstalled(feature, version);
    }

    protected void installAssertAndUninstallFeature(String feature) throws Exception {
        HashSet<Feature> featuresBefore = new HashSet<Feature>(Arrays.asList(this.featuresService.listInstalledFeatures()));
        try {
            this.featuresService.installFeature(feature);
            this.assertFeatureInstalled(feature);
        }
        finally {
            this.uninstallNewFeatures(featuresBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installAssertAndUninstallFeature(String feature, String version) throws Exception {
        HashSet<Feature> featuresBefore = new HashSet<Feature>(Arrays.asList(this.featuresService.listInstalledFeatures()));
        try {
            this.featuresService.installFeature(feature, version);
            this.assertFeatureInstalled(feature, version);
        }
        finally {
            this.uninstallNewFeatures(featuresBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installAssertAndUninstallFeatures(String ... feature) throws Exception {
        HashSet<Feature> featuresBefore = new HashSet<Feature>(Arrays.asList(this.featuresService.listInstalledFeatures()));
        try {
            for (String curFeature : feature) {
                this.featuresService.installFeature(curFeature);
                this.assertFeatureInstalled(curFeature);
            }
        }
        finally {
            this.uninstallNewFeatures(featuresBefore);
        }
    }

    protected void uninstallNewFeatures(Set<Feature> featuresBefore) {
        try {
            Feature[] features;
            for (Feature curFeature : features = this.featuresService.listInstalledFeatures()) {
                if (featuresBefore.contains(curFeature)) continue;
                try {
                    System.out.println("Uninstalling " + curFeature.getName());
                    this.featuresService.uninstallFeature(curFeature.getName(), curFeature.getVersion());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

