/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit5;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Ordered;
import org.apache.camel.spi.AutowiredLifecycleStrategy;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Language;
import org.apache.camel.support.LifecycleStrategySupport;

public class StubComponentAutowireStrategy
extends LifecycleStrategySupport
implements AutowiredLifecycleStrategy,
Ordered {
    private final CamelContext camelContext;
    private final String pattern;

    public StubComponentAutowireStrategy(CamelContext camelContext, String pattern) {
        this.camelContext = camelContext;
        this.pattern = pattern;
    }

    public int getOrder() {
        return 2147482647;
    }

    public void onComponentAdd(String name, Component component) {
        this.autowireComponent(name, component);
    }

    public void onDataFormatCreated(String name, DataFormat dataFormat) {
        this.autowireDataFormat(name, dataFormat);
    }

    public void onLanguageCreated(String name, Language language) {
        this.autowireLanguage(name, language);
    }

    private void autowireComponent(String name, Component component) {
        boolean enabled;
        boolean bl = enabled = this.camelContext.isAutowiredEnabled() != false && component.isAutowiredEnabled();
        if (enabled) {
            this.autowire(name, "component", component);
        }
    }

    private void autowireDataFormat(String name, DataFormat dataFormat) {
        boolean enabled = this.camelContext.isAutowiredEnabled();
        if (enabled) {
            this.autowire(name, "dataformat", dataFormat);
        }
    }

    private void autowireLanguage(String name, Language language) {
        boolean enabled = this.camelContext.isAutowiredEnabled();
        if (enabled) {
            this.autowire(name, "language", language);
        }
    }

    private void autowire(String name, String kind, Object target) {
        if (!this.pattern.contains(name)) {
            StubComponentAutowireStrategy.doAutoWire((String)name, (String)kind, (Object)target, (CamelContext)this.camelContext);
        }
    }
}

