/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit5;

import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.Service;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.test.junit5.CamelContextConfiguration;
import org.apache.camel.test.junit5.CamelContextManager;
import org.apache.camel.test.junit5.JunitPropertiesSource;
import org.apache.camel.test.junit5.TestExecutionConfiguration;
import org.apache.camel.test.junit5.TestSupport;
import org.apache.camel.test.junit5.util.CamelContextTestHelper;
import org.apache.camel.test.junit5.util.ExtensionHelper;
import org.apache.camel.test.junit5.util.RouteCoverageDumperExtension;
import org.apache.camel.test.junit5.util.RouteDumperExtension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransientCamelContextManager
implements CamelContextManager {
    private static final Logger LOG = LoggerFactory.getLogger(TransientCamelContextManager.class);
    private final TestExecutionConfiguration testConfigurationBuilder;
    private final CamelContextConfiguration camelContextConfiguration;
    private final Service service;
    private ModelCamelContext context;
    protected ProducerTemplate template;
    protected FluentProducerTemplate fluentTemplate;
    protected ConsumerTemplate consumer;
    private Properties extra;
    private ExtensionContext.Store globalStore;

    public TransientCamelContextManager(TestExecutionConfiguration testConfigurationBuilder, CamelContextConfiguration camelContextConfiguration) {
        this.testConfigurationBuilder = testConfigurationBuilder;
        this.camelContextConfiguration = camelContextConfiguration;
        this.service = camelContextConfiguration.camelContextService();
    }

    @Override
    public void createCamelContext(Object test) throws Exception {
        this.initialize(test);
    }

    @Override
    public void beforeContextStart(Object test) throws Exception {
        this.applyCamelPostProcessor(test);
        this.camelContextConfiguration.postProcessor().postSetup();
    }

    private void initialize(Object test) throws Exception {
        LOG.debug("Initializing a new CamelContext");
        if (this.testConfigurationBuilder.isJmxEnabled() || this.testConfigurationBuilder.isRouteCoverageEnabled() || TestSupport.isCamelDebugPresent()) {
            this.enableJMX();
        } else {
            this.disableJMX();
        }
        this.context = (ModelCamelContext)this.camelContextConfiguration.camelContextSupplier().createCamelContext();
        assert (this.context != null) : "No context found!";
        Method setContextMethod = test.getClass().getMethod("setContext", ModelCamelContext.class);
        setContextMethod.invoke(test, this.context);
        this.camelContextConfiguration.registryBinder().bindToRegistry(this.context.getRegistry());
        this.context.getShutdownStrategy().setTimeout((long)this.camelContextConfiguration.shutdownTimeout());
        if (this.camelContextConfiguration.useDebugger()) {
            CamelContextTestHelper.setupDebugger((CamelContext)this.context, this.camelContextConfiguration.breakpoint());
        }
        this.setupTemplates();
        String mockPattern = this.camelContextConfiguration.mockEndpoints();
        String mockAndSkipPattern = this.camelContextConfiguration.mockEndpointsAndSkip();
        CamelContextTestHelper.enableAutoMocking((CamelContext)this.context, mockPattern, mockAndSkipPattern);
        this.configurePropertiesComponent();
        this.configureIncludeExcludePatterns();
        this.beforeContextStart(test);
        if (this.testConfigurationBuilder.useRouteBuilder()) {
            this.setupRoutes();
            this.tryStartCamelContext();
        } else {
            CamelContextTestHelper.replaceFromEndpoints(this.context, this.camelContextConfiguration.fromEndpoints());
            LOG.debug("Using route builder from the created context: {}", (Object)this.context);
        }
        LOG.debug("Routing Rules are: {}", (Object)this.context.getRoutes());
    }

    private void setupTemplates() {
        this.template = this.context.createProducerTemplate();
        this.template.start();
        this.fluentTemplate = this.context.createFluentProducerTemplate();
        this.fluentTemplate.start();
        this.consumer = this.context.createConsumerTemplate();
        this.consumer.start();
    }

    private void configureIncludeExcludePatterns() {
        String include = this.camelContextConfiguration.routeFilterIncludePattern();
        String exclude = this.camelContextConfiguration.routeFilterExcludePattern();
        CamelContextTestHelper.configureIncludeExcludePatterns((CamelContext)this.context, include, exclude);
    }

    private void configurePropertiesComponent() {
        if (this.extra == null) {
            this.extra = this.camelContextConfiguration.useOverridePropertiesWithPropertiesComponent();
        }
        Boolean ignore = this.camelContextConfiguration.ignoreMissingLocationWithPropertiesComponent();
        CamelContextTestHelper.configurePropertiesComponent((CamelContext)this.context, this.extra, new JunitPropertiesSource(this.globalStore), ignore);
    }

    private void setupRoutes() throws Exception {
        RoutesBuilder[] builders = this.camelContextConfiguration.routesSupplier().createRouteBuilders();
        CamelContextTestHelper.setupRoutes((CamelContext)this.context, builders);
        CamelContextTestHelper.replaceFromEndpoints(this.context, this.camelContextConfiguration.fromEndpoints());
    }

    private void tryStartCamelContext() throws Exception {
        boolean skip = CamelContextTestHelper.isSkipAutoStartContext(this.testConfigurationBuilder);
        if (skip) {
            LOG.info("Skipping starting CamelContext as system property skipStartingCamelContext is set to be true or auto start context is false.");
        } else if (this.testConfigurationBuilder.isUseAdviceWith()) {
            LOG.info("Skipping starting CamelContext as isUseAdviceWith is set to true.");
        } else {
            CamelContextTestHelper.startCamelContextOrService((CamelContext)this.context, this.camelContextConfiguration.camelContextService());
        }
    }

    protected void disableJMX() {
        DefaultCamelContext.setDisableJmx((boolean)true);
    }

    protected void enableJMX() {
        DefaultCamelContext.setDisableJmx((boolean)false);
    }

    @Override
    public ModelCamelContext context() {
        return this.context;
    }

    @Override
    public ProducerTemplate template() {
        return this.template;
    }

    @Override
    public FluentProducerTemplate fluentTemplate() {
        return this.fluentTemplate;
    }

    @Override
    public ConsumerTemplate consumer() {
        return this.consumer;
    }

    @Override
    public Service camelContextService() {
        return this.service;
    }

    @Override
    public void startCamelContext() throws Exception {
        CamelContextTestHelper.startCamelContextOrService((CamelContext)this.context, this.camelContextConfiguration.camelContextService());
    }

    @Override
    public void stopCamelContext() {
        this.doStopCamelContext((CamelContext)this.context, this.camelContextConfiguration.camelContextService());
    }

    @Override
    public void stop() {
        TransientCamelContextManager.doStopTemplates(this.consumer, this.template, this.fluentTemplate);
        this.doStopCamelContext((CamelContext)this.context, this.service);
    }

    @Override
    public void stopTemplates() {
    }

    @Override
    public void close() {
    }

    private static void doStopTemplates(ConsumerTemplate consumer, ProducerTemplate template, FluentProducerTemplate fluentTemplate) {
        if (consumer != null) {
            consumer.stop();
        }
        if (template != null) {
            template.stop();
        }
        if (fluentTemplate != null) {
            fluentTemplate.stop();
        }
    }

    protected void doStopCamelContext(CamelContext context, Service camelContextService) {
        if (camelContextService != null) {
            camelContextService.stop();
        } else if (context != null) {
            context.stop();
        }
    }

    protected void applyCamelPostProcessor(Object test) throws Exception {
        boolean spring = ExtensionHelper.hasClassAnnotation(test.getClass(), "org.springframework.context.annotation.ComponentScan");
        if (!spring) {
            PluginHelper.getBeanPostProcessor((CamelContext)this.context).postProcessBeforeInitialization(test, test.getClass().getName());
            PluginHelper.getBeanPostProcessor((CamelContext)this.context).postProcessAfterInitialization(test, test.getClass().getName());
        }
    }

    @Override
    public void setGlobalStore(ExtensionContext.Store globalStore) {
        this.globalStore = globalStore;
    }

    @Override
    public void dumpRouteCoverage(Class<?> clazz, String currentTestName, long time) throws Exception {
        if (this.testConfigurationBuilder.isRouteCoverageEnabled()) {
            RouteCoverageDumperExtension wrapper = new RouteCoverageDumperExtension(this.context);
            wrapper.dumpRouteCoverage(clazz, currentTestName, time);
        }
    }

    @Override
    public void dumpRoute(Class<?> clazz, String currentTestName, String format) throws Exception {
        if (format != null && !"false".equals(format)) {
            RouteDumperExtension wrapper = new RouteDumperExtension(this.context);
            wrapper.dumpRoute(clazz, currentTestName, format);
        }
    }
}

