/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AvailablePortFinder {
    private static final Logger LOG = LoggerFactory.getLogger(AvailablePortFinder.class);
    private static final AvailablePortFinder INSTANCE = new AvailablePortFinder();
    private final Map<Integer, Port> portMapping = new ConcurrentHashMap<Integer, Port>();

    private AvailablePortFinder() {
    }

    public static Port find() {
        return INSTANCE.findPort();
    }

    synchronized Port findPort() {
        Port p;
        int port;
        Port prv;
        do {
            port = AvailablePortFinder.probePort(0);
            p = new Port(port);
        } while ((prv = AvailablePortFinder.INSTANCE.portMapping.putIfAbsent(port, p)) != null);
        return p;
    }

    synchronized Port findPort(int fromPort, int toPort) {
        for (int i = fromPort; i <= toPort; ++i) {
            try {
                int port = AvailablePortFinder.probePort(i);
                Port p = new Port(port);
                Port prv = AvailablePortFinder.INSTANCE.portMapping.putIfAbsent(port, p);
                if (prv != null) continue;
                return p;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Cannot find free port");
    }

    synchronized void release(Port port) {
        AvailablePortFinder.INSTANCE.portMapping.remove(port.getPort(), port);
    }

    public static int getNextAvailable() {
        try (Port port = INSTANCE.findPort();){
            int n = port.getPort();
            return n;
        }
    }

    public static int getNextAvailable(int fromPort, int toPort) {
        try (Port port = INSTANCE.findPort(fromPort, toPort);){
            int n = port.getPort();
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int probePort(int port) {
        try (ServerSocket ss = new ServerSocket();){
            ss.setReuseAddress(true);
            ss.bind(new InetSocketAddress((InetAddress)null, port), 1);
            int probedPort = ss.getLocalPort();
            LOG.info("Available port is -> {}", (Object)probedPort);
            int n = probedPort;
            return n;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot find free port", e);
        }
    }

    public class Port
    implements BeforeEachCallback,
    AfterAllCallback,
    AutoCloseable {
        final int port;
        String testClass;
        Throwable creation;

        public Port(int port) {
            this.port = port;
            this.creation = new Throwable();
        }

        public int getPort() {
            return this.port;
        }

        public void release() {
            AvailablePortFinder.this.release(this);
        }

        public String toString() {
            return Integer.toString(this.port);
        }

        public void beforeEach(ExtensionContext context) throws Exception {
            this.testClass = context.getTestClass().map(Class::getName).orElse(null);
            LOG.info("Registering port {} for test {}", (Object)this.port, (Object)this.testClass);
        }

        public void afterAll(ExtensionContext context) throws Exception {
            this.release();
        }

        @Override
        public void close() {
            this.release();
        }
    }
}

