/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.zookeeper.services;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class ZooKeeperContainer
extends GenericContainer<ZooKeeperContainer> {
    public static final String CONTAINER_NAME = "zookeeper";
    public static final int CLIENT_PORT = 2181;
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperContainer.class);

    public ZooKeeperContainer() {
        this(CONTAINER_NAME, -1);
    }

    public ZooKeeperContainer(int clientPort) {
        this(CONTAINER_NAME, clientPort);
    }

    public ZooKeeperContainer(String name) {
        this(name, -1);
        this.setWaitStrategy((WaitStrategy)Wait.forListeningPort());
        ((ZooKeeperContainer)((ZooKeeperContainer)this.withNetworkAliases(new String[]{name})).withExposedPorts(new Integer[]{2181})).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
    }

    public ZooKeeperContainer(String name, int clientPort) {
        super(name);
        this.setWaitStrategy((WaitStrategy)Wait.forListeningPort());
        ((ZooKeeperContainer)this.withNetworkAliases(new String[]{name})).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
        if (clientPort > 0) {
            this.addFixedExposedPort(clientPort, 2181);
        } else {
            this.withExposedPorts(new Integer[]{2181});
        }
    }

    public String getConnectionString() {
        return String.format("%s:%d", this.getHost(), this.getMappedPort(2181));
    }
}

