/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.zookeeper.services;

import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.zookeeper.services.ZooKeeperContainer;
import org.apache.camel.test.infra.zookeeper.services.ZooKeeperService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperLocalContainerService
implements ZooKeeperService,
ContainerService<ZooKeeperContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperLocalContainerService.class);
    private final ZooKeeperContainer container;

    public ZooKeeperLocalContainerService() {
        this(System.getProperty("zookeeper.container", "zookeeper:3.5"));
    }

    public ZooKeeperLocalContainerService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public ZooKeeperLocalContainerService(ZooKeeperContainer container) {
        this.container = container;
    }

    protected ZooKeeperContainer initContainer(String imageName) {
        if (imageName == null) {
            return new ZooKeeperContainer();
        }
        return new ZooKeeperContainer(imageName);
    }

    public void registerProperties() {
        System.setProperty("zookeeper.connection.string", this.getConnectionString());
    }

    public void initialize() {
        LOG.info("Trying to start the ZooKeeper container");
        this.container.start();
        this.registerProperties();
        LOG.info("ZooKeeper instance running at {}", (Object)this.getConnectionString());
    }

    public void shutdown() {
        LOG.info("Stopping the ZooKeeper container");
        this.container.stop();
    }

    public ZooKeeperContainer getContainer() {
        return this.container;
    }

    @Override
    public String getConnectionString() {
        return this.container.getConnectionString();
    }
}

