/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.xmpp.services;

import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.xmpp.services.XmppServerContainer;
import org.apache.camel.test.infra.xmpp.services.XmppService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmppLocalContainerService
implements XmppService,
ContainerService<XmppServerContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(XmppLocalContainerService.class);
    private XmppServerContainer container;

    public XmppLocalContainerService() {
        this(System.getProperty("xmpp.container", "5mattho/vysper-wrapper:0.3"));
    }

    public XmppLocalContainerService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public XmppLocalContainerService(XmppServerContainer container) {
        this.container = container;
    }

    protected XmppServerContainer initContainer(String imageName) {
        return new XmppServerContainer();
    }

    public void registerProperties() {
        System.setProperty("xmpp.url", this.getUrl());
        System.setProperty("xmpp.host", this.container.getHost());
        System.setProperty("xmpp.port", String.valueOf(this.container.getPortDefault()));
    }

    public void initialize() {
        LOG.info("Trying to start the Xmpp container");
        this.container.start();
        this.registerProperties();
        LOG.info("Xmpp instance running at {}", (Object)this.getUrl());
    }

    public void shutdown() {
        LOG.info("Stopping the Xmpp container");
        this.container.stop();
    }

    public XmppServerContainer getContainer() {
        return this.container;
    }

    @Override
    public String getUrl() {
        return this.container.getUrl();
    }

    @Override
    public String host() {
        return this.container.getHost();
    }

    @Override
    public int port() {
        return this.container.getPortDefault();
    }
}

