/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.solr.services;

import java.util.function.Consumer;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.solr.services.SolrLocalContainerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class SolrContainer
extends GenericContainer<SolrContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(SolrContainer.class);
    public static final String CONTAINER_NAME = "solr";

    public SolrContainer() {
        super(LocalPropertyResolver.getProperty(SolrLocalContainerService.class, (String)"solr.container"));
        ((SolrContainer)((SolrContainer)this.withNetworkAliases(new String[]{CONTAINER_NAME})).withExposedPorts(new Integer[]{8983})).waitingFor((WaitStrategy)Wait.forListeningPort());
    }

    public SolrContainer(String imageName) {
        super(DockerImageName.parse((String)imageName));
    }

    public static SolrContainer initContainer(String networkAlias, boolean cloudMode) {
        return (SolrContainer)((SolrContainer)((SolrContainer)((SolrContainer)((SolrContainer)new SolrContainer().withNetworkAliases(new String[]{networkAlias})).withExposedPorts(new Integer[]{8983})).withLogConsumer((Consumer)new Slf4jLogConsumer(LOG).withPrefix(CONTAINER_NAME))).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Server.*Started.*", (int)1))).withCommand(cloudMode ? "-c" : "");
    }
}

